---
title: Get started · Cloudflare BYOIP docs
description: Work with your account team to understand everything you need to
  ensure a smooth transition during the onboarding process.
lastUpdated: 2025-06-03T09:09:53.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/byoip/get-started/
  md: https://developers.cloudflare.com/byoip/get-started/index.md
---

Work with your account team to understand everything you need to ensure a smooth transition during the onboarding process.

Cloudflare requires a service-specific configuration for your prefixes, as well as some requirements common to all BYOIP customers regardless of service type.

## Requirements

The following requirements are common to all products compatible with BYOIP.

You must verify that your [Internet Routing Registry (IRR)](https://developers.cloudflare.com/byoip/concepts/irr-entries/) records are up to date and contain:

* `route` or `route6` objects matching the exact prefixes you want to onboard
* `origin` matching the correct ASN you want to onboard

RPKI validation

You are not required to use Resource Public Key Infrastructure (RPKI). However, if you do, make sure your ROAs are accurate. You can use [Cloudflare's RPKI Portal](https://rpki.cloudflare.com/?view=validator) and a second source such as [Routinator](https://rpki-validator.ripe.net/ui/) to double-check your prefixes.

## Process overview

Overall, the steps can be summarized as follows:

1. You revise your [IRRs and ROAs](#requirements) (if applicable) to make sure they are correct.
2. You prepare a [Letter of Agency (LOA)](https://developers.cloudflare.com/byoip/concepts/loa/) containing both the prefix you are authorizing Cloudflare to announce and which ASN they will be announced under. Cloudflare will present this to our transit partners as evidence that we are allowed to announce the route.
3. You use the [Upload LOA Document](https://developers.cloudflare.com/api/resources/addressing/subresources/loa_documents/methods/create/) API endpoint to submit the letter under your account and the [Add Prefix](https://developers.cloudflare.com/api/resources/addressing/subresources/prefixes/methods/create/) endpoint to create the prefix in your account with the associated `loa_document_id`.
4. After receiving the LOA, Cloudflare validates the [requirements](#requirements) and provisions the IPs.
5. (Optional) You can use [prefix delegations](https://developers.cloudflare.com/byoip/concepts/prefix-delegations/) to share all or part of your prefix with another Cloudflare account.
6. You use [service bindings](https://developers.cloudflare.com/byoip/service-bindings/)[1](#user-content-fn-1) and [address maps](https://developers.cloudflare.com/byoip/address-maps/)[2](#user-content-fn-2) to control how your IPs are used.
7. You advertise or withdraw the BGP route for a prefix via the [BGP Prefixes API](https://developers.cloudflare.com/api/resources/addressing/subresources/prefixes/subresources/bgp_prefixes/).

## Footnotes

1. Mappings that control through which pipeline traffic destined for a given IP address will be routed. [↩](#user-content-fnref-1)

2. Mappings that specify which IP addresses should be used when Cloudflare responds to DNS queries for proxied hostnames. [↩](#user-content-fnref-2)
