---
title: Client-side cloudflared · Cloudflare Zero Trust docs
description: With Cloudflare Zero Trust, users can connect to non-HTTP
  applications via a public hostname without installing the WARP client. This
  method requires you to onboard a domain to Cloudflare and install cloudflared
  on both the server and the user's device.
lastUpdated: 2025-10-24T20:47:24.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/access-controls/applications/non-http/cloudflared-authentication/
  md: https://developers.cloudflare.com/cloudflare-one/access-controls/applications/non-http/cloudflared-authentication/index.md
---

With Cloudflare Zero Trust, users can connect to non-HTTP applications via a public hostname without installing the WARP client. This method requires you to onboard a domain to Cloudflare and install `cloudflared` on both the server and the user's device.

Users log in to the application by running a `cloudflared access` command in their terminal. `cloudflared` will launch a browser window and prompt the user to authenticate with your identity provider.

Note

Automated services should only authenticate with `cloudflared` if they cannot use a [service token](https://developers.cloudflare.com/cloudflare-one/access-controls/service-credentials/service-tokens/). Cloudflared authentication relies on WebSockets to establish a connection. WebSockets have a known limitation where persistent connections may close unexpectedly. We recommend either a [Service Auth policy](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/#service-auth) or using [Warp to Tunnel routing](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/non-http/) in these instances.

For examples of how to connect to Access applications with client-side `cloudflared`, refer to these tutorials:

* [Connect through Access using a CLI](https://developers.cloudflare.com/cloudflare-one/tutorials/cli/)
* [Connect through Access using kubectl](https://developers.cloudflare.com/cloudflare-one/tutorials/kubectl/)
* [Connect over SSH with cloudflared](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/ssh/ssh-cloudflared-authentication/) (legacy) -- SSH connections are now managed through [Access for Infrastructure](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/ssh/ssh-infrastructure-access/).
* [Connect over RDP with cloudflared](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/rdp/#connect-to-rdp-server-with-cloudflared-access)
* [Connect over SMB with cloudflared](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/smb/)
* [Connect over arbitrary TCP with cloudflared](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/non-http/cloudflared-authentication/arbitrary-tcp/)
