---
title: API and Terraform · Cloudflare Zero Trust docs
description: This section covers a few common use cases with the API and
  Terraform to manage Cloudflare One. For more information, refer to our API
  documentation and Terraform reference guide.
lastUpdated: 2025-10-28T17:49:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/api-terraform/
  md: https://developers.cloudflare.com/cloudflare-one/api-terraform/index.md
---

This section covers a few common use cases with the API and Terraform to manage Cloudflare One. For more information, refer to our [API documentation](https://developers.cloudflare.com/api/) and [Terraform reference guide](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs).

* [Access API examples](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/)
* [Terraform](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-with-terraform/)

## Set dashboard to read-only

Super Administrators can lock all settings as read-only in Cloudflare One. Read-only mode ensures that all updates for the account are made through the API or Terraform.

To enable read-only mode:

1. In [Cloudflare One](https://one.dash.cloudflare.com/), go to **Settings** > **Admin controls**.
2. Enable **Set dashboard to read-only**.

All users, regardless of [user permissions](https://developers.cloudflare.com/cloudflare-one/roles-permissions/), will be prevented from making configuration changes through the UI.

## Scoped API tokens

The administrators managing policies and groups in Cloudflare One might be different from those responsible for configuring WAF custom rules or other Cloudflare settings. You can configure scoped API tokens so that team members and automated systems can manage Cloudflare One settings without having permission to modify other configurations in Cloudflare.

You can create a scoped API token [via the dashboard](https://developers.cloudflare.com/fundamentals/api/get-started/create-token/) or [via the API](https://developers.cloudflare.com/fundamentals/api/how-to/create-via-api/). For a list of available token permissions, refer to [API token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/).
