---
title: Configure text add-ons · Cloudflare Zero Trust docs
description: You can create custom labels to be used as the subject or body
  prefix for emails with specific dispositions.
lastUpdated: 2025-10-27T15:00:52.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/configure-text-add-ons/
  md: https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/configure-text-add-ons/index.md
---

You can create custom labels to be used as the subject or body prefix for emails with specific dispositions.

Note

You can only configure text add-ons if you deploy Email security via [MX/Inline](https://developers.cloudflare.com/cloudflare-one/email-security/setup/pre-delivery-deployment/mx-inline-deployment/).

Warning

If you currently do not have text add-ons enabled, configuring text add-ons will add a banner to the subject line. As a result, the subject line and the email body will be reduced.

## Subject prefix

To configure a subject prefix:

1. Log in to [Cloudflare One](https://one.dash.cloudflare.com/).
2. Select **Email security**.
3. Select **Settings**, then go to **Detection settings** > **Text add-ons** > **View**.
4. Select **Configure** > **Subject prefix**.
5. Populate each disposition with a subject prefix, and turn on the **Status** to enable the subject prefix for a specific disposition.

### Advanced settings

In **Advanced settings**, you can configure **Add "labels" variable**. This option allows you to add a dynamic value for a label that lists dispositions and allows for additional text.

To turn on **Add "labels" variable**:

1. Go to **Advanced settings** > **Add "labels" variable**.

2. Choose between:

   * **Use default**.
   * **Use custom "labels" variable**: Enter the custom label in the text box.

Once you have configured the subject prefix, select **Save**.

## Body prefix

A body prefix is a custom label added to the top of the email body for emails with specific dispositions.

Populate each disposition with a body prefix, and turn on the **Status** to enable the body prefix for a specific disposition.

### Advanced settings

In Advanced settings, you can configure **Add "labels" or "threat types" variable**. This option allows you to add a dynamic value for labels that lists dispositions, or threats that lists the threat types behind an assigned disposition.

To turn on **Add "labels" or "threat types" variable**:

1. Go to **Advanced settings**:

2. Choose between:

   * **Add "labels" variable**: This option allows you to add a dynamic value that for a label that lists dispositions and allows for additional text. Choose between:

     * **Use default**.
     * **Use custom "labels" variable**: Enter the custom label in the text box.

Once you have configured the body prefix, select **Save**.

### Add threat types variable

This option allows you to include a dynamic value for '%THREATS' that lists the threat types behind an assigned disposition. It can include additional, HTML-formatted text.

The dashboard will display **Default** or **Custom** (to use "labels" or "threat types" variable), depending on how you configured the [advanced settings](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/configure-text-add-ons/#advanced-settings-1).
