---
title: Before you begin · Cloudflare Zero Trust docs
description: "Before you start the onboarding process, you will have to:"
lastUpdated: 2025-10-27T15:00:52.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/email-security/setup/
  md: https://developers.cloudflare.com/cloudflare-one/email-security/setup/index.md
---

Before you start the onboarding process, you will have to:

1. Choose a deployment path: Email security provides two deployment modes, [post-delivery](https://developers.cloudflare.com/cloudflare-one/email-security/setup/post-delivery-deployment/) for API and BCC/Journaling and [pre-delivery](https://developers.cloudflare.com/cloudflare-one/email-security/setup/pre-delivery-deployment/) for MX/Inline.
2. Learn about dispositions, impersonation registry, and reclassifications.
3. Know the steps to configure your email environment correctly.

The following table compares features available across API, BCC/Journaling and MX/Inline:

| Feature | API | BCC | Journaling | MX/Inline |
| - | - | - | - | - |
| Deployment Type | Post-delivery | Post-delivery | Post-delivery | Pre-delivery (Inline) |
| Supported Email Provider | Microsoft 365 | Gmail, Microsoft 365 | Microsoft 365 | All email providers |
| Inspection Timing | Scans messages already in the mailbox | Scans a copy of the message upon delivery | Scans a copy of the message upon delivery | Scans the message before delivery |
| Mechanism | Uses MS Graph API to integrate with Microsoft 365. | Uses a BCC rule to send a copy to Cloudflare | Uses a Journal Rule in the Microsoft Purview portal | Changes MX records to point email traffic to Cloudflare |
| Message Remediation | Auto-moves through Read/Write API permissions | Auto-moves through Google or Microsoft integration | Auto-moves through Microsoft integration | Messages can be blocked, quarantined, or modified inline |
| Message Modification | Primarily deletion/move post-delivery | Primarily deletion/move post-delivery | Primarily deletion/move post-delivery. | Move post-delivery. Supports link actions and text add-ons.[1](#user-content-fn-1) |

[1](#user-content-fn-1) With [inline deployment](https://developers.cloudflare.com/cloudflare-one/email-security/setup/pre-delivery-deployment/mx-inline-deployment/), Cloudflare recommends setting up the integrations to allow post-delivery response and phish submission response to work. Refer to step 7 in [Auto-moves](https://developers.cloudflare.com/cloudflare-one/email-security/settings/auto-moves/) to learn more.

## 1. Choose a deployment

### Post-delivery deployment

When you choose post-delivery deployment, Cloudflare scans emails **after** they reach a users' inbox.

If you are a Microsoft 365 user, this is done via [Microsoft's Graph API](https://developers.cloudflare.com/cloudflare-one/email-security/setup/post-delivery-deployment/api/m365-api/) or [journaling](https://developers.cloudflare.com/cloudflare-one/email-security/setup/post-delivery-deployment/bcc-journaling/journaling-setup/m365-journaling/).

If you are a [Google Workspace](https://developers.cloudflare.com/cloudflare-one/email-security/setup/post-delivery-deployment/bcc-journaling/bcc-setup/gmail-bcc-setup/gmail-bcc-setup/) or [Microsoft Exchange](https://developers.cloudflare.com/cloudflare-one/email-security/setup/post-delivery-deployment/bcc-journaling/bcc-setup/bcc-microsoft-exchange/) user, this is done via BCC.

#### Why you should consider post-delivery deployment

Post-delivery deployment is time-efficient, because it does not involve MX changes. Post-delivery deployment does not disrupt mail flow. Post-delivery deployment allows you to enable [auto-move events](https://developers.cloudflare.com/cloudflare-one/email-security/settings/auto-moves/) to hard or soft delete messages, and synchronize your [directory](https://developers.cloudflare.com/cloudflare-one/email-security/directories/) when you use Microsoft Graph API or Google Workspace.

Note

When you choose post-delivery deployment:

* The threat is removed **after** the message has been delivered to the inbox.
* It requires API scopes, or BCC/Journaling rule configuration.
* Auto-move is only available in BCC/Journaling if you associate an integration.

### Pre-delivery deployment

When you choose pre-delivery deployment, Cloudflare scans emails **before** they reach a users' inbox. The MX record points to Cloudflare.

#### Why you should consider pre-delivery deployment

Pre-delivery deployment provides you with the highest level of protection. It enforces [text add-ons](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/configure-text-add-ons/) or link rewrite at delivery.

Pre-delivery blocks threats in transit, and it adds banners or texts before the user views the email.

Note

When you choose pre-delivery deployment:

* You must edit MX records or create a connector.
* You can enable auto-move events only after you associate an integration.
* Cloudflare [egress IPs](https://developers.cloudflare.com/cloudflare-one/email-security/setup/pre-delivery-deployment/egress-ips/) are allowed on downstream mail servers.

## 2. Understand dispositions

Dispositions allow you to configure policies and tune reporting. For example, you can configure a policy to move suspicious emails to your junk folder.

Refer to [Dispositions](https://developers.cloudflare.com/cloudflare-one/email-security/reference/dispositions-and-attributes/#dispositions) to learn more about dispositions.

## 3. Set up the impersonation registry

Most [business email compromise (BEC)](https://www.cloudflare.com/en-gb/learning/email-security/business-email-compromise-bec/) targets executives or finance roles. You must add addresses of roles who are likely to be impersonated. Refer to [Impersonation registry](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/impersonation-registry/) to learn how to add a user to the impersonation registry.

Roles you may want to include in the impersonation registry are:

* C-suites
* Finance roles
* HR
* IT help-desk
* Legal

You should review your impersonation registry on a quarterly basis as roles change.

## 4. Reclassify messages

A reclassification is a change to an email's disposition **after** initial scanning. It is Cloudflare's built-in feedback loop for correcting false positives/negatives **and** training the detection models to get smarter over time. Refer to [Reclassify messages](https://developers.cloudflare.com/cloudflare-one/email-security/investigation/search-email/#reclassify-messages) to learn how to reclassify a message.

### Who can reclassify messages

[Security teams](https://developers.cloudflare.com/cloudflare-one/email-security/monitoring/search-email/#team-submissions) and [end users](https://developers.cloudflare.com/cloudflare-one/email-security/monitoring/search-email/#user-submissions) can submit a reclassification.

### Why you should reclassify messages

Reclassifications are critical because:

* **They help improve model accuracy**: Every validated reclassification teaches Cloudflare's machine learning to recognise new lures, language, infrastructure, and benign patterns.
* **They reduce alert fatigue**: Correcting Suspicious or Spam emails that users actually want tailors detections to your organization, cutting noise in the dashboard.
* **They close the remediation loop**: When a disposition is upgraded to Malicious, Cloudflare auto-moves those emails out of every inbox (Graph API or Google Workspace API integrations).
* **They can help you log activity taken on any reclassification**: Each reclassification displays a submission ID, details about original, requested and final dispositions, and more. Refer to [Reclassify messages](https://developers.cloudflare.com/cloudflare-one/email-security/investigation/search-email/#reclassify-messages) to learn more about reclassifications.

To make the most of reclassifications:

1. Review reclassifications on a weekly basis.
2. Ensure you have an integration associated with any MX/Inline deployment. When you associate an integration, you will not need to upload the EMLs every time; Cloudflare can use APIs to receive a copy of your email messages.
3. Investigate any increase in [user submissions](https://developers.cloudflare.com/cloudflare-one/email-security/monitoring/search-email/#user-submissions) (users may have found a phish that bypassed filters) and confirm that analyst-final dispositions align with your policies.

A correct use of reclassifications ensures that Email security delivers a stronger protection with less manual tuning.

## 5. Configuration checklist

Follow the below checklist to ensure your email environment is set up correctly:

| Step | Post-delivery | Pre-delivery |
| - | - | - |
| Authorize integration ([Graph API](https://developers.cloudflare.com/cloudflare-one/email-security/setup/post-delivery-deployment/api/m365-api/#enable-microsoft-integration) or [Google Workspace](https://developers.cloudflare.com/cloudflare-one/email-security/setup/post-delivery-deployment/bcc-journaling/bcc-setup/gmail-bcc-setup/enable-gmail-integration/)) | Required[1](#user-content-fn-1) | Required [2](#user-content-fn-2) |
| Associate an integration with an MX/Inline domain | | Required |
| Add/verify domains | Required | Required |
| [Update MX records/connector](https://developers.cloudflare.com/cloudflare-one/email-security/setup/pre-delivery-deployment/mx-inline-deployment-setup/), then allow Cloudflare [egress IPs](https://developers.cloudflare.com/cloudflare-one/email-security/setup/pre-delivery-deployment/egress-ips/) on downstream mail server | | Required |
| Enable [Post‑delivery response and Phish submission response](https://developers.cloudflare.com/cloudflare-one/email-security/settings/auto-moves/) | Required | Required |
| Populate [impersonation registry](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/impersonation-registry/) and [allow](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/allow-policies/)/[block](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/blocked-senders/) lists | Required | Required |
| Configure [partner domain TLS](https://developers.cloudflare.com/cloudflare-one/email-security/setup/pre-delivery-deployment/partner-domain-tls/) and admin quarantine | | Required |
| Configure [text add-ons](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/configure-text-add-ons/) and [link actions](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/configure-link-actions/) | | Required |
| Send a test email and verify it appears in **Monitoring** > [**Email activity**](https://developers.cloudflare.com/cloudflare-one/email-security/monitoring/#email-activity) with expected disposition | Required | Required |

Now that you know which deployment path to choose, you can begin your onboarding process.

## Footnotes

1. Associating an integration with BCC/Journaling is required for post-delivery but not for pre-delivery. [↩](#user-content-fnref-1) [↩2](#user-content-fnref-1-2) [↩3](#user-content-fnref-1-3)

2. Still used for directory/auto‑move insight if desired as well as authorizing free API CASB. [↩](#user-content-fnref-2)
