---
title: Google Calendar (FedRAMP) · Cloudflare Zero Trust docs
description: The Google Calendar (FedRAMP) integration detects a variety of data
  loss prevention, account misconfiguration, and user security risks in an
  integrated Google Workspace account that could leave you and your organization
  vulnerable.
lastUpdated: 2025-10-24T15:44:40.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/google-workspace/google-calendar-fedramp/
  md: https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/google-workspace/google-calendar-fedramp/index.md
---

Availability

The Google Calendar (FedRAMP) CASB integration requires a special entitlement on your account. To request access, contact your account team.

The Google Calendar (FedRAMP) integration detects a variety of data loss prevention, account misconfiguration, and user security risks in an integrated Google Workspace account that could leave you and your organization vulnerable.

## Integration prerequisites

* A Google Workspace account with a Business Starter, Business Standard, Business Plus or Enterprise plan
* A Google Workspace user with [Super Admin privileges](https://support.google.com/a/answer/2405986) and [Owner permissions](https://cloud.google.com/iam/docs/understanding-roles) in the Google Cloud Platform (GCP) project used

## Integration permissions

Refer to [Google Workspace integration permissions](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/google-workspace/#integration-permissions) for information on which API permissions to enable.

## Security findings

The Google Calendar (FedRAMP) integration currently scans for the following findings, or security risks. Findings are grouped by category and then ordered by [severity level](https://developers.cloudflare.com/cloudflare-one/cloud-and-saas-findings/manage-findings/#severity-levels).

To stay up-to-date with new CASB findings as they are added, bookmark this page or subscribe to its [RSS feed](https://github.com/cloudflare/cloudflare-docs/commits/production/src/content/docs/cloudflare-one/integrations/cloud-and-saas/google-workspace/google-calendar-fedramp.mdx.atom).

### Calendar sharing

| Finding type | FindingTypeID | Severity | Description |
| - | - | - | - |
| Google Workspace: Calendar is publicly accessible | `ec68bf68-b0c0-47b3-ad48-fcb3d7eaf8b6` | Medium | A user's Google Calendar is publicly accessible on the Internet that anyone can read. |
