---
title: Centrify · Cloudflare Zero Trust docs
description: "Centrify secures access to infrastructure, DevOps, cloud, and
  other modern enterprise so you can prevent the number one cause of breaches:
  privileged access abuse."
lastUpdated: 2025-10-27T17:49:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/centrify/
  md: https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/centrify/index.md
---

Centrify secures access to infrastructure, DevOps, cloud, and other modern enterprise so you can prevent the number one cause of breaches: privileged access abuse.

## Set up Centrify as an OIDC provider

### 1. Create an application in Centrify

1. Log in to the Centrify administrator panel.

2. Select **Apps**.

3. Select **Add Web Apps**.

4. Select the **Custom** tab, then select **Add OpenID Connect**.

5. On the **Add Web App** screen, select **Yes** to create an OpenID Connect application.

6. Enter an **Application ID**.

   ![Centrify Settings with Application ID added](https://developers.cloudflare.com/_astro/centrify-4.C0i78_vc_Z1QPBsV.webp)

7. Select **Save**.

8. Select **Trust** in the **Settings** menu.

9. Enter a strong application secret on the **Trust** section.

10. Under **Service Provider Configuration** enter your application's authentication domain as the resource application URL.

11. Under **Authorized Redirect URIs**, select **Add**.

12. Under **Authorized Redirect URIs**, enter the following URL:

    ```txt
    https://<your-team-name>.cloudflareaccess.com/cdn-cgi/access/callback
    ```

    You can find your team name in [Cloudflare One](https://one.dash.cloudflare.com) under **Settings** > **Team name**.

    ![Centrify Trust Identity Provider Configuration with team domain and callback](https://developers.cloudflare.com/_astro/centrify-6.ChCQ_t69_Z2d4gi7.webp)

13. Select **Save**.

14. Copy the following values:

* **Client ID**
* **Client Secret**
* **OpenID Connect Issuer URL**
* **Application ID** from the **Settings** tab

1. Go to the **User Access** tab.

2. Select the roles to grant access to your application.

### 2. Add Centrify to Cloudflare One

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Integrations** > **Identity providers**.

2. Under **Your identity providers**, select **Add new identity provider**.

3. Paste in the **Client ID**, **Client Secret**, **Centrify account URL** and **Application ID**.

4. (Optional) To enable SCIM, refer to [Synchronize users and groups](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/generic-oidc/#synchronize-users-and-groups).

5. (Optional) Under **Optional configurations**, enter [custom OIDC claims](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/generic-oidc/#custom-oidc-claims) that you wish to add to your users' identity.

6. Select **Save**.

To test that your connection is working, go to **Integrations** > **Identity providers** and select **Test** next to the identity provider you want to test.

## Example API Config

```json
{
  "config": {
    "client_id": "<your client id>",
    "client_secret": "<your client secret>",
    "centrify_account": "https://abc123.my.centrify.com/",
    "centrify_app_id": "exampleapp"
  },
  "type": "centrify",
  "name": "my example idp"
}
```
