---
title: Identity providers · Cloudflare Zero Trust docs
description: Cloudflare One integrates with your organization's identity
  provider to apply Cloudflare One and Secure Web Gateway policies. If you work
  with partners, contractors, or other organizations, you can integrate multiple
  identity providers simultaneously.
lastUpdated: 2025-10-27T17:49:51.000Z
chatbotDeprioritize: false
tags: SSO
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/
  md: https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/index.md
---

Cloudflare One integrates with your organization's identity provider to apply Cloudflare One and Secure Web Gateway policies. If you work with partners, contractors, or other organizations, you can integrate multiple identity providers simultaneously.

As an alternative to configuring an identity provider, Cloudflare One can send a [one-time PIN (OTP)](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/one-time-pin/) to approved email addresses. No configuration needed — simply add a user's email address to an [Access policy](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/) and to the group that allows your team to reach the application. You can simultaneously configure an OTP and an identity provider to allow users to use their own authentication method.

Adding an identity provider as a login method requires configuration both in [Cloudflare One](https://one.dash.cloudflare.com) and with the identity provider itself. Consult our IdP-specific documentation to learn more about what you need to set up.

Note

Cloudflare One supports social identity providers that do not require administrator accounts, open source providers, and corporate providers. Cloudflare also supports using signed AuthN requests with SAML providers.

## Set up IdPs in Cloudflare One

* Dashboard

  1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Integrations** > **Identity providers**.

  2. In the **Your identity providers** card, select **Add new identity provider**.

  3. Select the identity provider you want to add.

     If you do not see your identity provider listed, these providers can typically still be enabled. If they support OIDC or OAuth, select the [generic OIDC](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/generic-oidc/) option. If they support SAML, select the [generic SAML](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/generic-saml/) option. Cloudflare supports all SAML and OIDC providers and can integrate with the majority of OAuth providers. If your provider supports both SAML and OIDC, we recommend OIDC for ease of configuration.

  4. Fill in the necessary fields to set up your identity provider.

     Each identity provider will have different required fields for you to fill in. Step-by-step instructions are shown in the dashboard side panel. Alternatively, refer to the [IdP-specific documentation](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/).

  5. Once you have filled in the necessary fields, select **Save**.

* Terraform (v5)

  1. Add the following permission to your [`cloudflare_api_token`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/api_token):

     * `Access: Organizations, Identity Providers, and Groups Write`

  2. Add an identity provider to Cloudflare One using the [`cloudflare_zero_trust_access_identity_provider`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/zero_trust_access_identity_provider) resource. For example, to add a Microsoft Entra ID integration:

     ```tf
     resource "cloudflare_zero_trust_access_identity_provider" "microsoft_entra_id" {
       account_id = var.cloudflare_account_id
       name       = "Entra ID example"
       type       = "azureAD"
       config      = {
         client_id                  = var.entra_id_client_id
         client_secret              = var.entra_id_client_secret
         directory_id               = var.entra_id_directory_id
         support_groups             = true
         }
     }
     ```

     Each identity provider integration has different required attributes. You will need to obtain these attribute values from your identity provider. For more information, refer to the [IdP-specific documentation](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/).

     If you do not see your identity provider listed, these providers can typically still be enabled. If they support OIDC or OAuth, use the [generic OIDC](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/generic-oidc/) option. If they support SAML, use the [generic SAML](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/generic-saml/) option. Cloudflare supports all SAML and OIDC providers and can integrate with the majority of OAuth providers. If your provider supports both SAML and OIDC, we recommend OIDC for ease of configuration.

Your IdP will now be listed in the **Login methods** card.

## Test IdPs in Cloudflare One

To test if an IdP is correctly configured:

1. Go to **Integrations** > **Identity providers**.
2. Select **Test** next to the IdP you would like to test. This will attempt to connect to the IdP to verify if a valid connection is established.

### Your provider is connected

If your provider is connected, another window will open in your browser, with this message:

!["Your connection works!" message displayed for a successful IdP test](https://developers.cloudflare.com/_astro/connected-idp.Dc_ZasM0_1Amy4H.webp)

### Your provider is not connected

If your provider is not connected, another window will open in your browser. Along with an error message, you will receive a detailed explanation of why the test has failed.

## Use The API

We recommend that you use our dashboard to configure your identity providers. However, if you would like to use the [Cloudflare API](https://api.cloudflare.com/), each of the identity provider topics covered here include an example API configuration snippet as well.
