---
title: Connect to SSH with client-side cloudflared (legacy) · Cloudflare Zero
  Trust docs
description: End users can connect to an SSH server without the WARP client by
  authenticating through cloudflared in their native terminal. This method
  requires having cloudflared installed on both the server machine and on the
  client machine, as well as an active zone on Cloudflare. The traffic is
  proxied over this connection, and the user logs in to the server with their
  Cloudflare Access credentials.
lastUpdated: 2025-10-21T14:33:19.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/ssh/ssh-cloudflared-authentication/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/ssh/ssh-cloudflared-authentication/index.md
---

Note

Not recommended for new deployments. We recommend using [Access for Infrastructure](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/ssh/ssh-infrastructure-access/) to connect to SSH.

End users can connect to an SSH server without the WARP client by authenticating through `cloudflared` in their native terminal. This method requires having `cloudflared` installed on both the server machine and on the client machine, as well as an active zone on Cloudflare. The traffic is proxied over this connection, and the user logs in to the server with their Cloudflare Access credentials.

Client-side `cloudflared` can be used in conjunction with [routing over WARP](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/ssh/ssh-warp-to-tunnel/) and [Access for Infrastructure](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/ssh/ssh-infrastructure-access/) so that there are multiple ways to connect to the server. You can reuse the same Cloudflare Tunnel when configuring each connection method.

## 1. Connect the server to Cloudflare

1. Create a Cloudflare Tunnel by following our [dashboard setup guide](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/get-started/create-remote-tunnel/).

2. In the **Published application routes** tab, choose a domain from the drop-down menu and specify any subdomain (for example, `ssh.example.com`).

3. For **Service**, select *SSH* and enter `localhost:22`. If the SSH server is on a different machine from where you installed the tunnel, enter `<server IP>:22`.

4. Select **Save**.

5. (Recommended) Add a [self-hosted application](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/self-hosted-public-app/) to Cloudflare Access in order to manage access to your server.

## 2. Connect as a user

1. [Install `cloudflared`](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/downloads/) on the client machine.

2. Make a one-time change to your SSH configuration file:

   ```sh
   vim ~/.ssh/config
   ```

3. Input the following values; replacing `ssh.example.com` with the hostname you created.

   ```txt
   Host ssh.example.com
   ProxyCommand /usr/local/bin/cloudflared access ssh --hostname %h
   ```

   The `cloudflared` path may be different depending on your OS and package manager. For example, if you installed `cloudflared` on macOS with Homebrew, the path is `/opt/homebrew/bin/cloudflared`.

4. You can now test the connection by running a command to reach the service:

   ```sh
   ssh <username>@ssh.example.com
   ```

   When the command is run, `cloudflared` will launch a browser window to prompt you to authenticate with your identity provider before establishing the connection from your terminal.
