---
title: Analytics · Cloudflare Zero Trust docs
description: Use WAN Tunnels' different analytic options for an overview of the
  performance of your sites, or to troubleshoot potential issues.
lastUpdated: 2025-10-27T11:06:15.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/analytics/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/analytics/index.md
---

WAN Tunnels customers can follow the troubleshooting steps listed below to gather information at the beginning of a troubleshooting process, then move to more detailed network data collection and analysis to identify the root cause of a problem.

* Overview in [WAN Tunnels Site Analytics](#wan-tunnels-site-analytics)

- Analyze network traffic data over time in [WAN Tunnels Network Analytics](#wan-tunnels-network-analytics)

- Perform more detailed troubleshooting with:

  * [Traceroutes](#traceroutes)
  * [Packet captures](#packet-captures)

## WAN Tunnels Site Analytics

WAN Tunnels Site Analytics provides an overview of the connectivity status and traffic analytics of all WAN Tunnels sites. This is a great place to start if you receive an alert, need to begin the WAN Tunnels troubleshooting process, or are performing routine monitoring.

Refer to [WAN Tunnels Site Analytics](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/analytics/site-analytics/) to learn more.

## WAN Tunnels Network Analytics

Network Analytics provides detailed analytics on WAN Tunnels traffic over time. Customers can filter data on specific traffic characteristics and view traffic analytics over time.

Refer to [WAN Tunnels Network Analytics to learn more.](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/analytics/network-analytics/)

## Traceroutes

Traceroutes provide a hop by hop breakdown of the Internet path network traffic follows as it traverses from Cloudflare's network to a customer's network.

Refer to [Traceroutes](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/analytics/traceroutes/) to learn more.

## Packet captures

Packet captures allow customers to analyze the raw packet data that a customer is sending and receiving from Cloudflare's network.

Refer to [packet captures](https://developers.cloudflare.com/magic-firewall/packet-captures/) to learn more.

## Query Analytics with GraphQL

GraphQL Analytics provides customers with a GraphQL API that they can query to receive raw JSON data of their WAN Tunnels traffic analytics. This data can be ingested into a SIEM or other tool and analyzed further.

* [Querying WAN Tunnels tunnel bandwidth analytics with GraphQL](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/analytics/query-bandwidth/)
* [Querying WAN Tunnels tunnel health check results with GraphQL](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/analytics/query-tunnel-health/)
