---
title: Enable NAT for a subnet · Cloudflare Zero Trust docs
description: Enable static NAT for subnets in Appliances to  re-use address spaces locally.
lastUpdated: 2025-10-27T11:06:15.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/appliances/network-options/nat-subnet/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/appliances/network-options/nat-subnet/index.md
---

Each subnet (directly-attached or routed) must have a unique address space within your WAN Tunnels. You can re-use address spaces locally by enabling static network address translation (NAT) for a subnet. NAT is static. This means that inbound connections - from WAN Tunnels to the site behind the Appliance - are allowed, and connections do not have to be initiated by hosts behind the Appliance. NAT is also 1:1, that is, the Appliance will translate between corresponding addresses in two equal-sized prefixes.

To enable NAT, supply a WAN-facing address prefix the same size as the subnet's prefix, and the Appliance will translate between the two.

For example:

* **Prefix**: `192.168.100.0/24`
* **Static NAT prefix**: `10.10.100.0/24`

With the example above, outbound traffic from host `192.168.100.13` in the subnet is translated to `10.10.100.13` in the Appliance (and vice versa for incoming traffic).

Note

Even if NAT is enabled, the local prefix for a subnet must be unique within its LAN. It can, however, be reused on other LANs or other sites. Overlay-facing prefixes - that is, a subnet's NAT prefix if NAT is enabled, and its local prefix otherwise - must always be unique across your whole WAN Tunnels.

## Create NATs for subnets

For more information on how to a create a NAT for a subnets, refer to **Create a LAN**, either in [Configure hardware Appliances](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/appliances/configure-hardware-connector/#create-a-lan) or in [Configure Virtual Appliances](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/appliances/configure-virtual-connector/#create-a-lan).
