---
title: Overview · Cloudflare Zero Trust docs
description: WAN Tunnels provides secure, performant connectivity and routing
  for your entire corporate networking, reducing cost and operation complexity.
  Magic Firewall integrates smoothly with WAN Tunnels, enabling you to enforce
  network firewall policies at Cloudflare's global network, across traffic from
  any entity within your network.
lastUpdated: 2025-10-27T11:06:15.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/index.md
---

Improve security and performance for your entire corporate networking, reducing cost and operation complexity.

Enterprise-only

WAN Tunnels provides secure, performant connectivity and [routing](https://www.cloudflare.com/learning/network-layer/what-is-routing/) for your entire corporate networking, reducing cost and operation complexity. [Magic Firewall](https://developers.cloudflare.com/magic-firewall/) integrates smoothly with WAN Tunnels, enabling you to enforce network firewall policies at Cloudflare's global network, across traffic from any entity within your network.

With WAN Tunnels, you can securely connect any traffic source - data centers, offices, devices, cloud properties - to Cloudflare's network and configure routing policies to get the bits where they need to go, all within one SaaS solution.

WAN Tunnels supports a variety of on-ramps including any device that supports anycast GRE or IPsec tunnels.

Refer to [On-ramps](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/on-ramps/) for a full list of supported on-ramps.

Learn how to [get started](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/get-started/).

***

## Features

### Connect your network automatically

Use Appliances to automatically connect, steer, and shape any IP traffic.

[Use Appliances](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/appliances/)

### Connect your network manually

WAN Tunnels is compatible with a host of third-party devices. If you do not have Appliances, start here to learn how to set up WAN Tunnels manually.

[Use a third-party device](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/third-party/)

### Zero Trust integration

Learn how you can use WAN Tunnels with other Cloudflare Zero Trust products.

[Integrate with other Zero Trust products](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/zero-trust/)

### BGP peering

Use BGP peering between your networks and Cloudflare to automate the process of adding or removing networks and subnets, and take advantage of failure detection and session recovery features.

[Use BGP peering](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/how-to/configure-routes/#configure-bgp-routes)

***

## Related products

**[Magic Firewall](https://developers.cloudflare.com/magic-firewall/)**

Magic Firewall is a firewall-as-a-service (FWaaS) delivered from the Cloudflare global network to protect office networks and cloud infrastructure with advanced, and scalable protection.

**[Cloudflare Network Interconnect](https://developers.cloudflare.com/network-interconnect/)**

Cloudflare Network Interconnect (CNI) allows you to connect your network infrastructure directly with Cloudflare - rather than using the public Internet - for a more reliable and secure experience.

**[Load Balancing](https://developers.cloudflare.com/load-balancing/)**

Cloudflare Load Balancing distributes traffic across your endpoints, which reduces endpoint strain and latency and improves the experience for end users.

***

## More resources

[Reference Architecture](https://developers.cloudflare.com/reference-architecture/architectures/sase/)

Deep dive into key architecture and functionalities aspects of Cloudflare One, and learn more about WAN Tunnels and its structure.
