---
title: File check · Cloudflare Zero Trust docs
description: The File Check device posture attribute checks for the presence of
  a file on a device. You can create multiple file checks for each operating
  system you need to run it on, or if you need to check for multiple files.
lastUpdated: 2025-10-27T17:49:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/warp-client-checks/file-check/
  md: https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/warp-client-checks/file-check/index.md
---

The File Check device posture attribute checks for the presence of a file on a device. You can create multiple file checks for each operating system you need to run it on, or if you need to check for multiple files.

## Prerequisites

* Cloudflare WARP client is [deployed](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/) on the device. For a list of supported modes and operating systems, refer to [WARP Client Checks](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/warp-client-checks/).

## Configure a file check

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Reusable components** > **Posture checks**.

2. Go to **WARP client checks** and select **Add a check**.

3. Select **File Check**.

4. You will be prompted for the following information:

   1. **Name**: Enter a unique name for this device posture check.
   2. **Operating system**: Select your operating system.
   3. **File Path**: Enter a file path (for example, `c:\my folder\myfile.exe`).
   4. **Signing certificate thumbprint (recommended)**: Enter the [thumbprint](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/warp-client-checks/application-check/#determine-the-signing-thumbprint) of the publishing certificate used to sign the file. Adding this information will enable the check to ensure that the file was signed by the expected software developer.
   5. **SHA-256 (optional)**: Enter the [SHA-256 value](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/warp-client-checks/application-check/#determine-the-sha-256-value) of the file. This is used to ensure the integrity of the file on the device.

5. Select **Save**.

Next, go to **Insights** > **Logs** > **Posture logs** and verify that the file check is returning the expected results.
