---
title: Enable Device Information Only · Cloudflare Zero Trust docs
description: Device Information Only mode allows you to enforce device posture
  rules when a user connects to your self-hosted Access application. This mode
  relies on a client certificate generated from your account to establish trust
  between the Access application and the device.
lastUpdated: 2025-10-24T18:24:10.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/device-information-only/
  md: https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/device-information-only/index.md
---

Feature availability

| System | Availability |
| - | - |
| Windows | ✅ |
| macOS | ✅ |
| Linux | ✅ |
| iOS | ✅ |
| Android | ✅ |
| ChromeOS | ✅ |

Device Information Only mode allows you to enforce device posture rules when a user connects to your [self-hosted Access application](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/self-hosted-public-app/). This mode relies on a client certificate generated from your account to establish trust between the Access application and the device.

## 1. Turn on account settings

Using the API, enable client certificate provisioning for [your zone](https://developers.cloudflare.com/fundamentals/account/find-account-and-zone-ids/):

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `SSL and Certificates Write`

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/devices/policy/certificates" \
  --request PATCH \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
  --json '{
    "enabled": true
  }'
```

## 2. Configure the WARP client

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Team & Resources** > **Devices** > **Device profiles**.

2. Under **Profiles**, choose a [device profile](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/device-profiles/) and select **Edit**.

3. For **Service mode**, select **Device Information Only**.

4. Select **Save profile**.

5. [Enroll your device](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/manual-deployment/) into your Zero Trust organization.

   When enrolled in Device Information Only mode, the WARP client will automatically generate a client certificate and install the certificate on the device. This certificate is necessary to confirm the source of outgoing traffic.

## 3. (Optional) Verify the client certificate

1. To view the client certificates installed on the device:

   * Windows

     1. Open the **Start** menu and select **Run**.
     2. Enter `certlm.msc`.
     3. Go to **Personal** > **Certificates**.

   * macOS

     1. Open **Keychain Access**.
     2. Go to **System** > **My Certificates**.

   * Linux

     Open a terminal window and run the following command:

     ```sh
     $ certutil -L -d sql:/etc/pki/nssdb
     ```

   * iOS

     Go to **Settings** > **General** > **About** > **Certificate Trust Settings**.

   * Android

     The location of the client certificate may vary depending on the Android device.

     * **Samsung**: Go to **Settings** > **Security** > **Other security settings** > **View security certificates**.
     * **Google Pixel**: Go to **Security** > **Advanced settings** > **Encryption & credentials** > **Credential storage**.

   * ChromeOS

     Go to **Settings** > **Apps** > **Google Play Store** > **Manage Android Preferences** > **Security** > **Credentials**.

   The client certificate name should match the **Device ID** in your WARP client **Preferences**.

2. To verify the client certificate in your Cloudflare account:

   1. In the [Cloudflare dashboard](https://dash.cloudflare.com/), select the zone for which you enabled client certificates.
   2. Go to **SSL/TLS** > **Client Certificates**.

   The certificate name is the WARP enrollment **Device ID**. ![Example client certificate in the Cloudflare dashboard](https://developers.cloudflare.com/_astro/device-information-only-cert.CBHcWmIc_W803o.webp)

## 4. Enforce the client certificate

To block traffic from devices that do not have a valid client certificate:

1. In the [Cloudflare dashboard](https://dash.cloudflare.com/), go to **SSL/TLS** > **Client Certificates**.

2. Under **Hosts**, select **Edit** and enter the hostname of your Access application (for example, `app.mycompany.com`). This enables mTLS authentication for the application.

3. Select **Create mTLS rule**.

4. Create a WAF custom rule that checks all requests to your application for a valid client certificate:

   | Field | Operator | Value | Logic | Action |
   | - | - | - | - | - |
   | Client Certificate | equals | Off | And | Block |
   | Hostname | equals | `app.mycompany.com` | | |

5. Select **Deploy**.

Device Information Only mode is now enabled on the device. To start enforcing device posture, set up a [WARP client check](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/warp-client-checks/) and add a *Require* device posture rule to your [Access policy](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/). When the device connects to the Access application for the first time, the browser will ask to use the client certificate installed by WARP.

![Browser prompts for client
certificate](https://developers.cloudflare.com/_astro/device-information-only-browser.BARL_mBj_2tjyFh.webp)

## Limitations

Device Information mode is not compatible with the [Windows pre-login](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/windows-prelogin/) feature. The user must be logged into Windows because WARP needs to [install a certificate](#3-optional-verify-the-client-certificate) in the user store.
