---
title: Captive portal detection · Cloudflare Zero Trust docs
description: Captive portals are used by public Wi-Fi networks (such as
  airports, coffee shops, and hotels) to make a user agree to their Terms of
  Service or provide payment before allowing access to the Internet. When a user
  connects to the Wi-Fi, the captive portal blocks all HTTPS traffic until the
  user completes a captive portal login flow in their browser. This prevents the
  WARP client from connecting to Cloudflare. At the same time, WARP creates
  firewall rules on the device to send all traffic to Cloudflare. The user is
  therefore unable to access the captive portal login screen unless they
  temporarily disable WARP.
lastUpdated: 2025-10-21T14:33:19.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/captive-portals/
  md: https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/captive-portals/index.md
---

Captive portals are used by public Wi-Fi networks (such as airports, coffee shops, and hotels) to make a user agree to their Terms of Service or provide payment before allowing access to the Internet. When a user connects to the Wi-Fi, the captive portal blocks all HTTPS traffic until the user completes a captive portal login flow in their browser. This prevents the WARP client from connecting to Cloudflare. At the same time, WARP creates [firewall rules](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/warp-architecture/#ip-traffic) on the device to send all traffic to Cloudflare. The user is therefore unable to access the captive portal login screen unless they temporarily disable WARP.

## Allow users to connect to captive portals

To allow users to connect through a captive portal, administrators can configure the following WARP settings:

### No user interaction required

* Enable [Captive portal detection](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#captive-portal-detection). This allows WARP to temporarily turn off when it detects a captive portal on the network. For more details, refer to [how captive portal detection works](#how-captive-portal-detection-works) and its [limitations](#limitations).
* Set [Device tunnel protocol](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#device-tunnel-protocol) to **MASQUE**. When using MASQUE, WARP traffic will look like standard HTTPS traffic and is therefore less likely to be blocked by captive portals.

### User interaction required

* Enable [Lock WARP switch](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#lock-warp-switch) and enable [Admin override](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#admin-override). Users can contact the IT administrator for a one-time code that allows them to manually turn off WARP and connect to a portal.
* For employees who travel, disable [Lock WARP switch](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#lock-warp-switch) and set an [Auto connect](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#auto-connect) duration. This allows the user to manually turn off WARP without contacting IT.

## How captive portal detection works

If WARP cannot establish a connection to Cloudflare, it will:

1. Start the captive portal timer.

2. Send a series of requests to the [Cloudflare captive portal URLs](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/firewall/#captive-portal) and other OS and browser-specific captive portal URLs. These requests are sent outside of the WARP tunnel.

3. If a request is intercepted, WARP assumes the network is behind a captive portal and fully opens the [system firewall](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/warp-architecture/#ip-traffic). While the firewall is open, all device traffic will bypass WARP.

4. Re-enable the firewall after the user successfully connects to the portal or after the timeout period expires.

## Limitations

* Due to [how captive portal detection works](#how-captive-portal-detection-works), it may be possible for an employee to spoof a captive portal in order to turn off WARP.

* Some captive portals, particularly those on airlines, may be slow to respond and exceed the captive portal detection timeout. Users will likely see a [CF\_CAPTIVE\_PORTAL\_TIMED\_OUT](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/troubleshooting/client-errors/#cf_captive_portal_timed_out) error when they try to connect. For context on the steps leading up to these errors, refer to [Connectivity status](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/troubleshooting/connectivity-status/).

* WARP may not be able to detect multi-stage captive portals, which redirect the user to different networks during the login process. Users will need to manually turn off WARP to get through the captive portal.

* Some public Wi-Fi networks are incompatible with running WARP:

  * Captive portals that intercept all DNS traffic will block WARP's [DoH connection](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/warp-architecture/#overview). Users will likely see a [CF\_NO\_NETWORK](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/troubleshooting/client-errors/#cf_no_network) error after they login to the captive portal.
  * Captive portals that only allow HTTPS traffic will block WARP's [Wireguard UDP connection](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/warp-architecture/#overview). Users will likely see a [CF\_HAPPY\_EYEBALLS\_MITM\_FAILURE](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/troubleshooting/client-errors/#cf_happy_eyeballs_mitm_failure) error after they login to the captive portal.

## Get captive portal logs Beta

Feature availability

| [WARP modes](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/) | [Zero Trust plans](https://www.cloudflare.com/teams-pricing/) |
| - | - |
| All modes | All plans |

| System | Availability | Minimum WARP version |
| - | - | - |
| Windows | ✅ | 2025.4.589.1 |
| macOS | ✅ | 2025.4.589.1 |
| Linux | ❌ | |
| iOS | ❌ | |
| Android | ❌ | |
| ChromeOS | ❌ | |

Captive portal logs are used by Cloudflare Support to troubleshoot WARP captive portal issues. When an end user reports an issue with a captive portal, the IT administrator can ask the user to collect captive portal logs on their device. The administrator can then attach the logs to a Cloudflare Support ticket.

To get captive portal logs:

1. Open the WARP client.
2. Go to **Settings** (gear icon) > **Preferences** > **Advanced**.
3. Select **Collect Captive Portal Diag**.
4. The WARP client will ask if the device is connected (or attempting to connect) to the Wi-Fi network that is causing issues. Select **Yes** to confirm.

macOS limitation

On macOS, [**Automatically join this network**](https://support.apple.com/guide/mac-help/wi-fi-settings-on-mac-mh11935/mac) should be enabled on the Wi-Fi network that is causing issues. This setting is enabled by default. If manually disabled, the captive portal diagnostic will fail to capture meaningful data and the device will not automatically reconnect to this network.

Once the diagnostic finishes running, WARP will place a `warp-captive-portal-diag-<date>-<time>.zip` file on the user's desktop. The end user can now share this file with their IT administrator.

## Related resources

* [Connectivity status](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/troubleshooting/connectivity-status/) - Learn about the status messages displayed by the WARP client during its connection process, and understand each stage as WARP establishes a secure tunnel to Cloudflare.
