---
title: Common issues · Cloudflare Zero Trust docs
description: This section covers the most common issues you might encounter as
  you deploy the WARP client in your organization, or turn on new features that
  interact with the client. If you do not see your issue listed below, refer to
  the troubleshooting FAQ or contact Cloudflare Support.
lastUpdated: 2025-10-24T18:24:10.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/troubleshooting/common-issues/
  md: https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/troubleshooting/common-issues/index.md
---

This section covers the most common issues you might encounter as you deploy the WARP client in your organization, or turn on new features that interact with the client. If you do not see your issue listed below, refer to the [troubleshooting FAQ](https://developers.cloudflare.com/cloudflare-one/faq/troubleshooting/) or [contact Cloudflare Support](https://developers.cloudflare.com/support/contacting-cloudflare-support/).

## Unable to connect WARP

If WARP is stuck in the `Disconnected` state or frequently changes between `Connected` and `Disconnected`, this indicates that the client cannot establish a connection to Cloudflare's global network.

![Example of WARP client UI when unable to turn on WARP](https://developers.cloudflare.com/_astro/warp-stuck-on-disconnected.B4_MhRve_260ELD.webp)

In your [WARP debug logs](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/troubleshooting/warp-logs/), `daemon.log` will typically show one or more of the following errors:

* Happy Eyeball checks failing:

  ```txt
  ERROR main_loop: warp::warp::happy_eyeballs: Happy eyeballs error Custom { kind: NotConnected, error: "All Happy Eyeballs checks failed" }
  ```

* Many other checks timing out:

  ```txt
  ERROR warp::warp::connectivity_check: DNS check failed error=ResolveError { kind: Timeout }
  WARN warp::warp::connectivity_check: Tunnel trace failed request::Error { kind: Request, url: Url { scheme: "https", cannot_be_a_base: false, username: "", password: None, host: Some(Domain("connectivity.cloudflareclient.com")), port: None, path: "/cdn-cgi/trace", query: None, fragment: None }, source: TimedOut }
  ```

Here are the most common reasons why this issue occurs:

### A third-party service is blocking WARP

A third-party service (such as a hardware or software firewall, router, MDM/group policy configuration, or other networking interface) may have a security policy in place which blocks WARP from connecting.

#### Solution

Configure the third-party service to exempt the [IP addresses required by WARP](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/firewall/).

### A third-party VPN is interfering with WARP

The most common places we see interference with WARP from VPNs are:

* **Control of traffic routing:** In `daemon.log`, you will see a large number of routing table changes. For example,

  ```txt
  DEBUG warp::warp_service: Routes changed:
      Added; Interface: 8; Destination: 10.133.27.201/32; Next hop: 100.64.0.2;
      Added; Interface: 8; Destination: 10.133.27.202/32; Next hop: 100.64.0.2;
  DEBUG warp::warp_service: Routes changed:
      Added; Interface: 8; Destination: 10.133.27.203/32; Next hop: 100.64.0.2;
      Added; Interface: 8; Destination: 10.133.27.204/32; Next hop: 100.64.0.2;
  DEBUG warp::warp_service: Routes changed:
      Added; Interface: 8; Destination: 10.133.27.205/32; Next hop: 100.64.0.2;
  ```

  This indicates that a third-party VPN is fighting WARP for control over the routing table.

* **Control of DNS:** In `daemon.log`, you will see a large number of DNS changes followed by this warning:

  ```txt
  WARN main_loop: warp::warp_service: Reinforcing DNS settings. Is something else fighting us?
  ```

  The daemon may also note that some other process has already bound to the UDP and TCP sockets:

  ```txt
  WARN warp::warp: Unable to bind local UDP socket error=Os { code: 48, kind: AddrInUse, message: "Address already in use" } sockaddr=127.0.2.2:53
  WARN warp::warp: Unable to bind local TCP socket error=Os { code: 48, kind: AddrInUse, message: "Address already in use" } sockaddr=127.0.2.2:53
  ```

To confirm that the VPN is the source of the issue, temporarily uninstall (not disable or disconnect) the VPN.

#### Solution

1. Disable all DNS enforcement on the VPN. WARP must be the last client to touch the primary and secondary DNS server on the default interface.
2. In [Cloudflare One](https://one.dash.cloudflare.com/), create a [Split Tunnel rule](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/) to exclude the VPN server you are connecting to (for example, `vpnserver.3rdpartyvpn.example.com`).
3. Configure your VPN to only include routes to your internal resources. Make sure that the VPN routes do not overlap with the routes [included in the WARP tunnel](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/).

For more information, refer to our [guide](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/vpn/) for running VPNs alongside the WARP client.

### Your ISP or country is blocking WARP

Some countries explicitly block the use of VPN or VPN-like software that intentionally encrypts traffic. These blocks are often inconsistently enforced and you may sometimes see successful connections.

If you suspect your country may be blocking WARP traffic, contact your ISP to verify.

### (Mac/Linux) The device's `/etc/resolv.conf` file has an invalid character

WARP cannot parse `resolv.conf` files which contain an invalid hostname. In `daemon.log`, you will see an `unrecognized char` warning:

```txt
WARN main_loop: warp::warp_service: Tunnel connection experienced error error=Custom { kind: Other, error: ProtoError { kind: Msg("unrecognized char:  ") } }
```

#### Solution

1. Open the `/etc/resolv.conf` file on your device.
2. In the `search` directives, check for invalid URL characters such as `!@#$%^&*()<>?`.
3. Remove the invalid lines and rely on WARP and Gateway for DNS services.

## Turned on WARP and can no longer browse the Internet

If WARP shows as `Connected` but you cannot reach any websites or internal resources, this is likely due to one of the following configuration issues.

### A Gateway firewall policy is blocking traffic

A misconfigured Gateway firewall policy can result in traffic to some or all sites being restricted.

#### Solution

1. In [Cloudflare One](https://one.dash.cloudflare.com/), go to **Traffic policies** > **Firewall policies**.
2. Disable all DNS, Network, and HTTP policies and see if the issue persists. It may take up to two minutes for the change to take effect. Note that all policy enforcement happens on the Cloudflare global network, not on your local device.
3. Slowly re-enable your policies. Once you have narrowed down the issue, modify the policies or their [order of enforcement](https://developers.cloudflare.com/cloudflare-one/traffic-policies/order-of-enforcement/).

### The device does not have a root certificate installed

Installing and trusting a [root CA](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/user-side-certificates/) is a necessary step to enable advanced security features such as Browser Isolation, [TLS decryption](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/tls-decryption/), AV scanning, and device posture.

If the root CA is not installed on the device, you will see untrusted certificate warnings on every website. Example warnings include `Certificate not trusted`, `Not trusted identity` or `SSL Error`.

#### Solution

[Install a Cloudflare certificate](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/user-side-certificates/manual-deployment/) on all of your devices, or [upload your own certificate](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/user-side-certificates/custom-certificate/) to Cloudflare.

Note

More and more applications (including browsers) are relying on their own certificate stores. In addition to ensuring a root certificate is trusted at the device level, you may also need to [add the certificate to individual applications](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/user-side-certificates/manual-deployment/#add-the-certificate-to-applications). For example, to use Firefox on Linux, you must install the certificate on both the system and on Firefox.

### A third-party security product is interfering with Gateway

WARP does not allow third-party DLP or proxy services to perform TLS decryption on traffic sent to Gateway.

To diagnose the issue, go to `https://zero-trust-client.cloudflareclient.com/v0/client_config` and verify the certificate the HTTPS traffic is signed with. If the certificate is issued by your organization or a third-party service, the third-party service is performing TLS decryption on WARP traffic and re-signing with a certificate that we do not trust.

#### Solution

In the third-party security product, disable HTTPS inspection and TLS decryption for the [WARP IP addresses](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/firewall/).

### Docker container is failing DNS resolution

If you are using WARP and running a CI/CD pipeline inside a Docker container on Microsoft hardware to provide GitHub Actions with an egress IP, your container's `/etc/resolv.conf` file might be injecting a [custom nameserver with the IP address `168.63.129.16`](https://learn.microsoft.com/en-us/azure/virtual-network/what-is-ip-address-168-63-129-16) (specific to Azure infrastructure.) The `168.63.129.16` IP address is only accessible to Azure VMs and causes the container's traffic to fail when routed through the Cloudflare WARP tunnel.

#### Solution

To fix this issue, you must exclude the Azure-specific nameserver IP (`168.63.129.16`) from being routed through WARP tunnel. Refer to [Split Tunnels](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/#change-split-tunnels-mode) and follow the instructions to exclude the Azure-specific IP.

## Cannot connect to a specific app or website

Below are the most common reasons why turning on WARP blocks a specific application from loading.

### TLS Decryption is enabled and the app or site does certificate pinning

Some applications do not support SSL inspection or are otherwise [incompatible with TLS decryption](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/tls-decryption/#inspection-limitations). Gateway provides a [list of applications known to perform certificate pinning](https://developers.cloudflare.com/cloudflare-one/traffic-policies/application-app-types/#do-not-inspect-applications).

#### Solution (if the app has a private certificate store)

Applications such as Firefox, Docker, Python, and npm rely on their own certificate store and the Cloudflare root certificate must be trusted in each.

Refer to [our instructions](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/user-side-certificates/manual-deployment/#add-the-certificate-to-applications) for adding a root certificate to common applications. For applications not on our list, try searching the Internet for `<app-name> proxy support` or `<app-name> proxy certificate`.

#### Solution (last resort)

If you cannot install the certificate on the application, create a [Do Not Inspect policy](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/#do-not-inspect) to exclude the application from Gateway inspection.

### A Gateway firewall policy is blocking the app or site

You may have a Gateway DNS, Network, or HTTP in place that accidentally blocks a port, IP, or domain that the app or site relies on.

#### Solution

1. In [Cloudflare One](https://one.dash.cloudflare.com/), go to **Traffic policies** > **Firewall policies**.
2. Disable all DNS, Network, and HTTP policies and see if the issue persists. It may take up to two minutes for the change to take effect. Note that all policy enforcement happens on the Cloudflare global network, not on your local device.
3. Slowly re-enable your policies. Once you have narrowed down the issue, modify the policies or their [order of enforcement](https://developers.cloudflare.com/cloudflare-one/traffic-policies/order-of-enforcement/).

### Split Tunnel settings are misconfigured for the app or site

Some applications require traffic to flow either all inside or all outside of the WARP tunnel. For instance, in order to use AirDrop or communicate with a local printer, traffic must be outside the tunnel. For applications like Microsoft Teams to function properly, all Microsoft Teams traffic must be either fully inside the tunnel or fully outside the tunnel.

#### Solution

1. Determine the IP addresses and/or domains required for your application to function. Common Internet search terms include `<app-name> split tunnel list`, `<app-name> allow list`, or `<app-name> firewall ips`.
2. In [Cloudflare One](https://one.dash.cloudflare.com/), go to your [Split Tunnel settings](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/).
3. Depending on the application, either include or exclude all of the necessary IPs and/or domains. For Microsoft applications, we provide a [one-click action](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#directly-route-microsoft-365-traffic) to exclude all Microsoft 365 IPs.

## Troubleshooting

* [Troubleshooting](https://developers.cloudflare.com/cloudflare-one/faq/troubleshooting/) - Browse other Cloudflare One-related troubleshooting errors and solutions.
