---
title: Domain categories · Cloudflare Zero Trust docs
description: Cloudflare Gateway allows you to block known and potential security
  risks on the public Internet, as well as specific categories of content.
  Domains are categorized by Cloudforce One, Cloudflare's threat intelligence
  solution. To review the categories for a specific domain, use Cloudflare
  Radar.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/traffic-policies/domain-categories/
  md: https://developers.cloudflare.com/cloudflare-one/traffic-policies/domain-categories/index.md
---

Cloudflare Gateway allows you to block known and potential security risks on the public Internet, as well as specific categories of content. Domains are categorized by [Cloudforce One](https://developers.cloudflare.com/security-center/cloudforce-one/), Cloudflare's threat intelligence solution. To review the categories for a specific domain, use [Cloudflare Radar](https://developers.cloudflare.com/radar/glossary/#content-categories).

Cloudflare categorizes domains into content categories and security categories, which cover security risks and security threats:

* **Content categories**: An upstream vendor supplies content categories for domains. These categories help us organize domains into broad topic areas. However, the specific criteria and methods used by our vendor may not be disclosed.
* **Security risks**: Cloudflare determines security risks for domains using internal models. These models analyze various factors, including the age of a domain and its reputation. This allows us to identify potentially risky domains.
* **Security threats**: To identify malicious domains that pose security threats, Cloudflare employs a mix of internal data sources, machine learning models, commercial feeds, and open-source threat intelligence.

You can block security and content categories by creating DNS or HTTP policies. Once you have configured your policies, you will be able to inspect network activity and the associated categories in your Gateway logs.

To request changes to a domain's categorization, refer to [Change categorization](https://developers.cloudflare.com/security-center/investigate/change-categorization/). For more information on investigating potentially risky domains, refer to [Investigate threats](https://developers.cloudflare.com/security-center/investigate/investigate-threats/#domain).

Subdomain category

Subdomains that have not been assigned a category will inherit the category of their parent domain. When Gateway categorizes a subdomain, the subdomain will carry only its own category. Categorized subdomains will not inherit their parent domain's categories.

## Security categories

| Category | Definition |
| - | - |
| Anonymizer | Sites that allow users to surf the Internet anonymously. |
| Brand Embedding | Sites that imitate a verified brand, for example `facobook.com`. |
| Command and Control & Botnet | Sites that are queried by compromised devices to exfiltrate information or potentially infect other devices in a network. |
| Compromised Domain | Sites where a legitimate domain has been compromised or taken over and had malicious content planted or injected. |
| Cryptomining | Sites that mine cryptocurrency by taking over the user's computing resources. |
| DGA Domains | Domains detected as generated by algorithms seen in malware. |
| DNS Tunneling | Domains with detected DNS tunneling activity. |
| Malware | Sites hosting malicious content and other compromised websites. |
| Phishing | Domains that are known for stealing personal information. |
| Potentially Unwanted Software | Domains that distribute software that may come bundled with other less legitimate software or functionality, like toolbars, adware, and grayware. |
| Private IP Address | Domains that resolve to private IP Addresses. |
| Scam | Fraudulent websites and schemes designed to trick victims into giving away money or personal information. |
| Spam | Sites that are known for targeting users with unwanted sweepstakes, surveys, and advertisements. |
| Spyware | Sites that are known to distribute or contain code that displays unwanted advertisements or that gathers user information without the user's knowledge. |

## Content categories

| Category | Definition |
| - | - |
| Ads | Sites that are hosting content related to advertising. |
| Adult Themes | Sites that are hosting content related to pornography, nudity, sexuality, and other adult themes. |
| Business & Economy | Sites that are related to business, economy, finance, education, science and technology. |
| Child Abuse | Sites hosting child abuse content. |
| CIPA | Sites related to aiding schools and organizations in abiding by CIPA requirements. |
| Education | Sites hosting educational content that are not included in other categories like Science, Technology or Educational institutions. |
| Entertainment | Sites that are hosting entertaining content that are not included in other categories like Comic books, Audio streaming, Video streaming etc. |
| Gambling | Sites that are providing online gambling or are related to gambling. |
| Government & Politics | Sites related to government and politics. |
| Health | Sites containing information about health and fitness. |
| Information Technology | Sites related to information technology. |
| Internet Communication | Sites hosting applications that are used for communication like chat, mail etc. |
| Job Search & Careers | Sites that facilitate searching for jobs and careers. |
| Miscellaneous | Sites that are not included in the listed security and content categories. |
| Questionable Content | Sites hosting content that are related to hacking, piracy, profanity and other questionable activities. |
| Real Estate | Sites related to real estate. |
| Religion | Sites hosting content about religion, alternative religion, religious teachings, religious groups, and spirituality. |
| Security Risks | Sites that are [new or misconfigured](#security-risk-subcategories). We recommend that you allow or isolate this content category to avoid accidentally blocking trusted domains. |
| Shopping & Auctions | Sites that are hosting content related to ecommerce, coupons, shopping, auctions and marketplaces. |
| Social & Family | Sites related to society and lifestyle. |
| Society & Lifestyle | Sites hosting information about lifestyle that are not included in other categories like fashion, food & drink etc. |
| Sports | Sites related to sports & recreation. |
| Technology | Sites hosting information about technology that are not included in the science category. |
| Travel | Sites that contain information about listings, reservations, services for travel. |
| Vehicles | Sites related vehicles, automobiles, including news, reviews, and other hobbyist information. |
| Violence | Sites hosting and/or promoting violent content. |
| Weather | Sites related to weather. |

### Miscellaneous subcategories

| Category | Definition |
| - | - |
| Login Screens | Sites hosting login screens that might also be included in other categories. |
| Miscellaneous | Sites that do not belong to other content categories. |
| No Content | Sites that have no content. |
| Redirect | Domains that redirect to other sites. |
| Unreachable | Domains that resolve to unreachable IP addresses. |

### Security risk subcategories

| Category | Definition |
| - | - |
| New Domains | Domains registered within the past 30 days. |
| Newly Seen Domains | Domains that were resolved for the first time within the past 30 days. |
| Parked & For Sale Domains | Domains that are not connected to a hosting service. |

### Category and subcategory IDs

| Category ID | Category Name | Subcategory ID | Subcategory Name |
| - | - | - | - |
| 1 | Ads | 66 | Advertisements |
| 2 | Adult Themes | 67 | Adult Themes |
| 2 | Adult Themes | 125 | Nudity |
| 2 | Adult Themes | 133 | Pornography |
| 3 | Business & Economy | 186 | Brokerage & Investing |
| 3 | Business & Economy | 75 | Business |
| 3 | Business & Economy | 89 | Economy & Finance |
| 3 | Business & Economy | 183 | Cryptocurrency |
| 3 | Business & Economy | 185 | Personal Finance |
| 6 | Education | 90 | Education |
| 6 | Education | 91 | Educational Institutions |
| 6 | Education | 189 | Reference |
| 6 | Education | 144 | Science |
| 6 | Education | 150 | Space & Astronomy |
| 7 | Entertainment | 70 | Arts |
| 7 | Entertainment | 74 | Audio Streaming |
| 7 | Entertainment | 76 | Cartoons & Anime |
| 7 | Entertainment | 79 | Comic Books |
| 7 | Entertainment | 92 | Entertainment |
| 7 | Entertainment | 96 | Fine Art |
| 7 | Entertainment | 100 | Gaming |
| 7 | Entertainment | 106 | Home Video/DVD |
| 7 | Entertainment | 107 | Humor |
| 7 | Entertainment | 116 | Magazines |
| 7 | Entertainment | 120 | Movies |
| 7 | Entertainment | 121 | Music |
| 7 | Entertainment | 122 | News & Media |
| 7 | Entertainment | 127 | Paranormal |
| 7 | Entertainment | 139 | Radio |
| 7 | Entertainment | 156 | Television |
| 7 | Entertainment | 164 | Video Streaming |
| 8 | Gambling | 99 | Gambling |
| 9 | Government & Politics | 190 | Charity and Non-profit |
| 9 | Government & Politics | 101 | Government/Legal |
| 9 | Government & Politics | 137 | Politics, Advocacy, and Government-Related |
| 10 | Health | 103 | Health & Fitness |
| 10 | Health | 146 | Sex Education |
| 12 | Internet Communication | 77 | Chat |
| 12 | Internet Communication | 98 | Forums |
| 12 | Internet Communication | 108 | Information Security |
| 12 | Internet Communication | 110 | Instant Messengers |
| 12 | Internet Communication | 111 | Internet Phone & VOIP |
| 12 | Internet Communication | 118 | Messaging |
| 12 | Internet Communication | 126 | P2P |
| 12 | Internet Communication | 129 | Personal Blogs |
| 12 | Internet Communication | 168 | Webmail |
| 12 | Internet Communication | 172 | Photo Sharing |
| 13 | Job Search & Careers | 113 | Job Search & Careers |
| 15 | Miscellaneous | 115 | Login Screens |
| 15 | Miscellaneous | 119 | Miscellaneous |
| 15 | Miscellaneous | 124 | No Content |
| 15 | Miscellaneous | 141 | URL Alias/Redirect |
| 15 | Miscellaneous | 161 | Unreachable |
| 17 | Questionable Content | 85 | Deceptive Ads |
| 17 | Questionable Content | 87 | Drugs |
| 17 | Questionable Content | 102 | Hacking |
| 17 | Questionable Content | 135 | Profanity |
| 17 | Questionable Content | 138 | Questionable Activities |
| 17 | Questionable Content | 157 | Militancy, Hate & Extremism |
| 17 | Questionable Content | 162 | Unreliable Information |
| 18 | Real Estate | 140 | Real Estate |
| 19 | Religion | 142 | Religion & Spirituality |
| 20 | Safe for Kids | 143 | Safe for Kids |
| 21 | Security threats | 68 | Anonymizer |
| 21 | Security threats | 80 | Command and Control & Botnet |
| 21 | Security threats | 187 | Compromised Domain |
| 21 | Security threats | 83 | Cryptomining |
| 21 | Security threats | 117 | Malware |
| 21 | Security threats | 131 | Phishing |
| 21 | Security threats | 188 | Potentially unwanted software |
| 21 | Security threats | 134 | Private IP Address |
| 21 | Security threats | 151 | Spam |
| 21 | Security threats | 153 | Spyware |
| 21 | Security threats | 175 | DNS Tunneling |
| 21 | Security threats | 176 | Domain Generation Algorithm |
| 21 | Security threats | 178 | Brand Embedding |
| 21 | Security threats | 191 | Scam |
| 22 | Shopping & Auctions | 73 | Auctions & Marketplaces |
| 22 | Shopping & Auctions | 82 | Coupons |
| 22 | Shopping & Auctions | 88 | Ecommerce |
| 22 | Shopping & Auctions | 148 | Shopping |
| 24 | Society & Lifestyle | 71 | Arts & Crafts |
| 24 | Society & Lifestyle | 72 | Astrology |
| 24 | Society & Lifestyle | 78 | Clothing |
| 24 | Society & Lifestyle | 84 | Dating & Relationships |
| 24 | Society & Lifestyle | 86 | Digital Postcards |
| 24 | Society & Lifestyle | 93 | Parenting |
| 24 | Society & Lifestyle | 94 | Fashion |
| 24 | Society & Lifestyle | 97 | Food & Drink |
| 24 | Society & Lifestyle | 104 | Hobbies & Interests |
| 24 | Society & Lifestyle | 105 | Home & Garden |
| 24 | Society & Lifestyle | 114 | Lifestyle |
| 24 | Society & Lifestyle | 130 | Pets |
| 24 | Society & Lifestyle | 132 | Photography |
| 24 | Society & Lifestyle | 136 | Professional Networking |
| 24 | Society & Lifestyle | 147 | Sexuality |
| 24 | Society & Lifestyle | 149 | Social Networks |
| 24 | Society & Lifestyle | 154 | Swimsuits |
| 24 | Society & Lifestyle | 158 | Tobacco |
| 24 | Society & Lifestyle | 173 | Body Art |
| 24 | Society & Lifestyle | 174 | Lingerie & Bikini |
| 24 | Society & Lifestyle | 181 | Alcohol |
| 25 | Sports | 152 | Sports |
| 26 | Technology | 69 | APIs |
| 26 | Technology | 81 | Content Servers |
| 26 | Technology | 95 | File Sharing |
| 26 | Technology | 109 | Information Technology |
| 26 | Technology | 123 | News, Portal & Search |
| 26 | Technology | 145 | Search Engines |
| 26 | Technology | 155 | Technology |
| 26 | Technology | 159 | Translator |
| 26 | Technology | 184 | Artificial Intelligence |
| 26 | Technology | 192 | Remote Access |
| 26 | Technology | 193 | Shareware/Freeware |
| 26 | Technology | 194 | Keep Awake Software |
| 27 | Travel | 160 | Travel |
| 28 | Vehicles | 163 | Vehicles |
| 29 | Violence | 165 | Violence |
| 29 | Violence | 166 | Weapons |
| 30 | Weather | 167 | Weather |
| 31 | Always blocked | 170 | Child Abuse |
| 32 | Security Risks | 128 | Parked & For Sale Domains |
| 32 | Security Risks | 169 | New Domains |
| 32 | Security Risks | 177 | Newly Seen Domains |
| 34 | CIPA | 182 | CIPA Filter |

## Filtering options

### Filter traffic by resolved IP category

When creating a DNS policy for security or content categories, you can optionally turn on **Filter traffic by resolved IP category** in the policy settings. When turned on, Gateway will block queries based on their resolved IP address in addition to the domain name. This setting may increase the number of false positives because domains in the blocked category can share IP addresses with legitimate domains.

### Ignore `CNAME` domain categories

The categories for a site's `CNAME` records may differ from its `A` record. For example, `blog.example.com` may be categorized under Personal Blogs, while `example.com` is categorized under Technology. To limit matches for a DNS policy to only the root domain's categories, turn on **Ignore CNAME domain categories**.

Regardless of this setting, `CNAME` domain categories will still appear in your Gateway [Logpush](https://developers.cloudflare.com/cloudflare-one/insights/logs/logpush/) logs.

## Categorization process

Cloudflare's domain categorization engine begins with multiple data sources, including:

1. Cloudflare's proprietary data using our global network.

2. Third-party intelligence feeds. Cloudflare uses data from over 30 open-source intelligence feeds and premium commercial feeds, such as Avira and Zvelo.

Then, the initial categorization is refined via:

1. Machine learning models. Our algorithms, including DGA Domains, DNS tunneling, and phishing detection models analyze patterns and behaviors to detect new and evolving threats.

2. Community feedback. Through a review process, Cloudflare assesses feedback by both our internal models and threat analysts. This ensures that our categorizations reflect the most current and accurate threat intelligence.

## Terraform

Terraform users can retrieve the category list with the `cloudflare_zero_trust_gateway_categories_list` data source. This allows you to create Gateway policies with the category's name rather than its numeric ID. For example:

```tf
data "cloudflare_zero_trust_gateway_categories_list" "categories" {
  account_id = var.cloudflare_account_id
}


locals {
  main_categories_map = {
    for idx, c in data.cloudflare_zero_trust_gateway_categories_list.categories[0].result :
    c.name => c.id
  }


  subcategories_map = merge(flatten([
    for idx, c in data.cloudflare_zero_trust_gateway_categories_list.categories[0].result : {
      for k, v in coalesce(c.subcategories, []) :
      v.name => v.id
    }
  ])...)
}


resource "cloudflare_zero_trust_gateway_policy" "zt_block_dns_tech_categories" {
  account_id = var.cloudflare_account_id
  name       = "DNS Blocked"
  action     = "block"
  traffic    = "any(dns.content_category[*] in {${join(" ", [
    local.main_categories_map["Technology"],
    local.subcategories_map["APIs"],
    local.subcategories_map["Artificial Intelligence"],
    local.subcategories_map["Content Servers"],
    local.subcategories_map["Translator"]
  ])}})"
}
```
