---
title: Host selectors · Cloudflare Zero Trust docs
description: When Gateway receives a DNS query for hostname covered by the
  Application, Content Categories, Domain, and Host selectors in an Egress
  policy, Gateway initially resolves DNS to an IP in the 100.80.0.0/16 or
  2606:4700:0cf1:4000::/64 range. This process allows Gateway to map a
  destination IP with a hostname at layer 4 (where Gateway evaluates Egress
  policies). The destination IP for a hostname is not usually known at layer 4.
  Prior to evaluating Egress policies, the initially resolved IP is overwritten
  with the correct destination IP.
lastUpdated: 2025-10-28T13:40:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/host-selectors/
  md: https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/host-selectors/index.md
---

Feature availability

| [WARP modes](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/) | [Zero Trust plans](https://www.cloudflare.com/teams-pricing/) |
| - | - |
| Gateway with WARP | Enterprise |

| System | Availability | Minimum WARP version |
| - | - | - |
| Windows | ✅ | 2025.4.929.0 |
| macOS | ✅ | 2025.4.929.0 |
| Linux | ✅ | 2025.4.929.0 |
| iOS | ❌ | |
| Android | ❌ | |
| ChromeOS | ❌ | |

When Gateway receives a DNS query for hostname covered by the [Application](https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/#application), [Content Categories](https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/#content-categories), [Domain](https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/#domain), and [Host](https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/#host) selectors in an Egress policy, Gateway initially resolves DNS to an IP in the `100.80.0.0/16` or `2606:4700:0cf1:4000::/64` range. This process allows Gateway to map a destination IP with a hostname at [layer 4](https://www.cloudflare.com/learning/ddos/glossary/open-systems-interconnection-model-osi/) (where Gateway evaluates Egress policies). The destination IP for a hostname is not usually known at layer 4. Prior to evaluating Egress policies, the initially resolved IP is overwritten with the correct destination IP.

![Example egress policy flow](https://developers.cloudflare.com/_astro/host-selector-diagram.MWSMsbT4_4QdTE.webp)

Additional configuration is required when using policies with these selectors.

## Turn on Host selectors

To turn on the selectors for your account:

* Dashboard

  1. In [Cloudflare One](https://one.dash.cloudflare.com/), go to **Traffic policies** > **Traffic settings**.
  2. In **Policy settings**, turn on **Allow egress policy host selectors**.

* API

  Use the [Patch Zero Trust account configuration](https://developers.cloudflare.com/api/resources/zero_trust/subresources/gateway/subresources/configurations/methods/edit/) endpoint to update your Zero Trust configuration. For example:

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/configuration" \
    --request PATCH \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "settings": {
          "host_selector": {
              "enabled": true
          }
      }
    }'
  ```

## Prerequisites

Traffic must be on-ramped to Gateway with the following methods:

| On-ramp method | Compatibility |
| - | - |
| [WARP](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/) | ✅ |
| [PAC files](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/agentless/pac-files/) | ✅ |
| [Browser Isolation](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/) | ✅ |
| [WARP Connector](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-connector/) | ❌ |
| [Magic WAN](https://developers.cloudflare.com/magic-wan/zero-trust/cloudflare-gateway/) | ❌ |

Unsupported traffic will be resolved with your default Gateway settings. If you use DNS locations to send a DNS query to Gateway with IPv4, IPv6, DoT, or DoH, Gateway will not return the initial resolved IP for supported traffic nor resolve unsupported traffic.

### Configuration changes

Warning

Gateway will overwrite the DNS response for all supported traffic, even if you use identity or device posture selectors to limit which users or devices are affected by the policy. In these cases, while the DNS response is overwritten, Gateway will still apply the correct Egress policy. Therefore, the configuration changes below must be applied to all of your users and device profiles.

To configure your Zero Trust organization to use Host selectors with Egress policies:

1. Ensure you have deployed [WARP version 2025.4.929.0](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/) or later on your users' desktop devices. If you need to apply your policies to mobile devices or devices running a version of WARP prior to 2025.4.929.0, add and deploy the following key-value pair to your devices' [WARP configuration file](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/) (`mdm.xml` on Windows and Linux or `com.cloudflare.warp.plist` on macOS):

   ```xml
   <array>
     <dict>
       <key>doh_in_tunnel</key>
       <true/>
     </dict>
   </array>
   ```

1) In your WARP [device profile](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/device-profiles/), configure your [Split Tunnel](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/) depending on the mode:

   * Exclude IPs and domains

     1. [Remove the route](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/#remove-a-route) to the IP address `100.64.0.0/10` from your Split Tunnel exclude list.

     2. [Add routes](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/#add-a-route) to exclude the following IP addresses:

        * `100.64.0.0/12`
        * `100.81.0.0/16`
        * `100.82.0.0/15`
        * `100.84.0.0/14`
        * `100.88.0.0/13`
        * `100.96.0.0/11`

   * Include IPs and domains

     1. Add the required [Zero Trust domains](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/#cloudflare-zero-trust-domains) or [IP addresses](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/#cloudflare-zero-trust-ip-addresses) to your Split Tunnel include list.
     2. [Add a route](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/#add-a-route) to include the IP address `100.80.0.0/16`.

The WARP client must be set to *Gateway with WARP* mode for traffic affected by these selectors to route correctly.
