---
title: Set up HTTP filtering · Cloudflare Zero Trust docs
description: Secure Web Gateway allows you to inspect HTTP traffic and control
  which websites users can visit.
lastUpdated: 2025-10-28T13:40:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/traffic-policies/initial-setup/http/
  md: https://developers.cloudflare.com/cloudflare-one/traffic-policies/initial-setup/http/index.md
---

Secure Web Gateway allows you to inspect HTTP traffic and control which websites users can visit.

Note

For a more detailed guide to filtering HTTP requests and other traffic for your organization, refer to the [Secure your Internet traffic and SaaS apps](https://developers.cloudflare.com/learning-paths/secure-internet-traffic/concepts/) implementation guide.

## 1. Connect to Gateway

To filter HTTP requests from a device:

1. [Install the Cloudflare root certificate](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/user-side-certificates/) on your device.
2. [Install the WARP client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/) on your device.
3. In the WARP client Settings, log in to your organization's Cloudflare One instance.
4. [Enable the Gateway proxy](https://developers.cloudflare.com/cloudflare-one/traffic-policies/proxy/#turn-on-the-gateway-proxy) for TCP. Optionally, you can enable the UDP proxy to inspect all port 443 UDP traffic.
5. To inspect HTTPS traffic, [enable TLS decryption](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/tls-decryption/#turn-on-tls-decryption).
6. (Optional) To scan file uploads and downloads for malware, [enable anti-virus scanning](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/antivirus-scanning/).

## 2. Verify device connectivity

To verify your device is connected to Cloudflare One:

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Traffic policies** > **Traffic settings**.
2. Under **Log traffic activity**, enable activity logging for all HTTP logs.
3. On your device, open a browser and go to any website.
4. In Cloudflare One, go to **Insights** > **Logs** > **Gateway** > **HTTP**.
5. Make sure HTTP requests from your device appear.

## 3. Create your first HTTP policy

To create a new HTTP policy:

* Dashboard

  1. In [Cloudflare One](https://one.dash.cloudflare.com/), go to **Traffic policies** > **Firewall policies**.

  2. In the **HTTP** tab, select **Add a policy**.

  3. Name the policy.

  4. Under **Traffic**, build a logical expression that defines the traffic you want to allow or block.

  5. Choose an **Action** to take when traffic matches the logical expression. For example, if you have configured TLS decryption, some applications that use [embedded certificates](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/tls-decryption/#inspection-limitations) may not support HTTP inspection, such as some Google products. You can create a policy to bypass inspection for these applications:

     | Selector | Operator | Value | Action |
     | - | - | - | - |
     | Application | in | *Do Not Inspect* | Do Not Inspect |

     Cloudflare also recommends adding a policy to block [known threats](https://developers.cloudflare.com/cloudflare-one/traffic-policies/domain-categories/#security-categories) such as Command & Control, Botnet and Malware based on Cloudflare's threat intelligence:

     | Selector | Operator | Value | Action |
     | - | - | - | - |
     | Security Categories | in | *All security risks* | Block |

  6. Select **Create policy**.

* API

  1. [Create an API token](https://developers.cloudflare.com/fundamentals/api/get-started/create-token/) with the following permissions:

     | Type | Item | Permission |
     | - | - | - |
     | Account | Zero Trust | Edit |

  2. (Optional) Configure your API environment variables to include your [account ID](https://developers.cloudflare.com/fundamentals/account/find-account-and-zone-ids/) and API token.

  3. Send a `POST` request to the [Create a Zero Trust Gateway rule](https://developers.cloudflare.com/api/resources/zero_trust/subresources/gateway/subresources/rules/methods/create/) endpoint. For example, if you have configured TLS decryption, some applications that use [embedded certificates](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/tls-decryption/#inspection-limitations) may not support HTTP inspection, such as some Google products. You can create a policy to bypass inspection for these applications:

     Required API token permissions

     At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

     * `Zero Trust Write`

     ```bash
     curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
       --request POST \
       --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
       --json '{
         "name": "Do not inspect applications",
         "description": "Bypass TLS decryption for unsupported applications",
         "precedence": 0,
         "enabled": true,
         "action": "off",
         "filters": [
             "http"
         ],
         "traffic": "any(app.type.ids[*] in {16})",
         "identity": "",
         "device_posture": ""
       }'
     ```

     ```sh
     {
        "success": true,
        "errors": [],
        "messages": []
     }
     ```

     The API will respond with a summary of the policy and the result of your request.

     Cloudflare also recommends adding a policy to block [known threats](https://developers.cloudflare.com/cloudflare-one/traffic-policies/domain-categories/#security-categories) such as Command & Control, Botnet and Malware based on Cloudflare's threat intelligence:

     Required API token permissions

     At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

     * `Zero Trust Write`

     ```bash
     curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
       --request POST \
       --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
       --json '{
         "name": "Block known risks",
         "description": "Block all default Cloudflare HTTP security categories",
         "precedence": 0,
         "enabled": true,
         "action": "block",
         "filters": [
             "http"
         ],
         "traffic": "any(http.request.uri.security_category[*] in {68 178 80 83 176 175 117 131 134 151 153})",
         "identity": "",
         "device_posture": ""
       }'
     ```

For more information, refer to [HTTP policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/).

## 4. Add optional policies

Refer to our list of [common HTTP policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/common-policies) for other policies you may want to create.
