---
title: Common network policies · Cloudflare Zero Trust docs
description: The following policies are commonly used to secure network traffic.
lastUpdated: 2025-10-23T22:25:50.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/traffic-policies/network-policies/common-policies/
  md: https://developers.cloudflare.com/cloudflare-one/traffic-policies/network-policies/common-policies/index.md
---

The following policies are commonly used to secure network traffic.

Refer to the [network policies page](https://developers.cloudflare.com/cloudflare-one/traffic-policies/network-policies/) for a comprehensive list of other selectors, operators, and actions.

## Block unauthorized applications

Note

After seven days, view your [Shadow IT SaaS Analytics](https://developers.cloudflare.com/cloudflare-one/insights/analytics/shadow-it-discovery/) and block additional applications based on what your users are accessing.

To minimize the risk of [shadow IT](https://www.cloudflare.com/learning/access-management/what-is-shadow-it/), some organizations choose to limit their users' access to certain web-based tools and applications. For example, the following policy blocks known AI tools:

* Dashboard

  | Selector | Operator | Value | Action |
  | - | - | - | - |
  | Application | in | *Artificial Intelligence* | Block |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "Block unauthorized applications",
      "description": "Block access to unauthorized AI applications",
      "enabled": true,
      "action": "block",
      "filters": [
          "l4"
      ],
      "traffic": "any(app.type.ids[*] in {25})",
      "identity": "",
      "device_posture": ""
    }'
  ```

## Check user identity

Configure access on a per user or group basis by adding [identity-based conditions](https://developers.cloudflare.com/cloudflare-one/traffic-policies/identity-selectors/) to your policies.

* Dashboard

  | Selector | Operator | Value | Logic | Action |
  | - | - | - | - | - |
  | Application | in | *Salesforce* | And | Block |
  | User Group Names | in | *Contractors* | | |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "Check user identity",
      "description": "Block access to Salesforce by temporary employees and contractors",
      "enabled": true,
      "action": "block",
      "filters": [
          "l4"
      ],
      "traffic": "any(app.ids[*] in {606})",
      "identity": "any(identity.groups.name[*] in {\"Contractors\"})",
      "device_posture": ""
    }'
  ```

## Enforce device posture

Require devices to have certain software installed or other configuration attributes. For instructions on enabling a device posture check, refer to the [device posture section](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/). For example, you can use a list of [device serial numbers](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/warp-client-checks/corp-device/) to ensure users can only access an application if they connect with the WARP client from a company device:

In the following example, you can use a list of [device serial numbers](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/warp-client-checks/corp-device/) to ensure users can only access an application if they connect with the WARP client from a company device:

* Dashboard

  | Selector | Operator | Value | Logic | Action |
  | - | - | - | - | - |
  | SNI Domain | is | `internalapp.com` | And | Block |
  | Passed Device Posture Checks | not in | *Device serial numbers* | | |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "All-NET-ApplicationAccess-Allow",
      "description": "Ensure access to the application comes from authorized WARP clients",
      "precedence": 70,
      "enabled": false,
      "action": "block",
      "filters": [
          "l4"
      ],
      "traffic": "any(net.sni.domains[*] == \"internalapp.com\")",
      "device_posture": "not(any(device_posture.checks.passed[*] in {\"<DEVICE_SERIAL_NUMBERS_LIST_UUID>\"}))"
    }'
  ```

  To get the UUIDs of your device posture checks, use the [List device posture rules](https://developers.cloudflare.com/api/resources/zero_trust/subresources/devices/subresources/posture/methods/list/) endpoint.

* Terraform

  ```tf
  resource "cloudflare_zero_trust_gateway_policy" "all_net_applicationaccess_allow" {
    account_id  = var.cloudflare_account_id
    name        = "All-NET-ApplicationAccess-Allow"
    description = "Ensure access to the application comes from authorized WARP clients"
    precedence  = 70
    enabled     = false
    action      = "block"
    filters     = ["l4"]
    traffic     = "any(net.sni.domains[*] == \"internalapp.com\")"
    posture      =  "not(any(device_posture.checks.passed[*] in {\"${"$"}${cloudflare_zero_trust_list.allowed_devices_sn_list.id}\"}))"
  }
  ```

## Enforce session duration

To require users to re-authenticate after a certain amount of time has elapsed, configure [WARP sessions](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-sessions/).

## Allow only approved traffic

Restrict user access to only the specific sites or applications configured in your [HTTP policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/).

### 1. Allow HTTP and HTTPS traffic

* Dashboard

  | Selector | Operator | Value | Logic | Action |
  | - | - | - | - | - |
  | Detected Protocol | is | *TLS* | And | Allow |
  | Destination Port | in | `80`, `443` | | |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "Allow HTTP and HTTPS traffic",
      "description": "Restrict traffic to HTTP and HTTPS traffic",
      "enabled": true,
      "action": "allow",
      "filters": [
          "l4"
      ],
      "traffic": "net.detected_protocol == \"tls\" and net.dst.port in {80 443}",
      "identity": "",
      "device_posture": ""
    }'
  ```

### 2. Block all other traffic

* Dashboard

  | Selector | Operator | Value | Action |
  | - | - | - | - |
  | Protocol | in | *TCP*, *UDP* | Block |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "Block all other traffic",
      "description": "Block all other traffic that is not HTTP or HTTPS",
      "enabled": true,
      "action": "block",
      "filters": [
          "l4"
      ],
      "traffic": "net.protocol in {\"tcp\" \"udp\"}",
      "identity": "",
      "device_posture": ""
    }'
  ```

## Filter HTTPS traffic when inspecting on all ports

If your organization blocks traffic by default with a network policy and you want to [inspect HTTP traffic on all ports](https://developers.cloudflare.com/cloudflare-one/traffic-policies/network-policies/protocol-detection/#inspect-on-all-ports), you need to explicitly allow HTTP and TLS traffic to filter it.

* Dashboard

  | Selector | Operator | Value | Logic | Action |
  | - | - | - | - | - |
  | Detected Protocol | is | *TLS* | Or | Allow |
  | Detected Protocol | is | *HTTP* | | |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "Allow on inspect all ports",
      "description": "Filter HTTPS traffic when using inspect all ports",
      "enabled": true,
      "action": "allow",
      "filters": [
          "l4"
      ],
      "traffic": "net.detected_protocol == \"tls\" or net.detected_protocol == \"http\"",
      "identity": "",
      "device_posture": ""
    }'
  ```

## Restrict access to private networks

Restrict access to resources which you have connected through [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/).

The following example consists of two policies: the first allows specific users to reach your application, and the second blocks all other traffic.

### 1. Allow company employees

* Dashboard

  | Selector | Operator | Value | Logic | Action |
  | - | - | - | - | - |
  | Destination IP | in | `10.0.0.0/8` | And | Allow |
  | User Email | matches regex | `.*@example.com` | | |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "Allow company employees",
      "description": "Allow any users with an organization email to reach the application",
      "enabled": true,
      "action": "allow",
      "filters": [
          "l4"
      ],
      "traffic": "net.dst.ip in {10.0.0.0/8}",
      "identity": "identity.email matches \".*@example.com\"",
      "device_posture": ""
    }'
  ```

### 2. Block everyone else

* Dashboard

  | Selector | Operator | Value | Action |
  | - | - | - | - |
  | Destination IP | in | `10.0.0.0/8` | Block |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "Block everyone else",
      "description": "Block any other users from accessing the application",
      "enabled": true,
      "action": "block",
      "filters": [
          "l4"
      ],
      "traffic": "net.dst.ip in {10.0.0.0/8}",
      "identity": "",
      "device_posture": ""
    }'
  ```

## Override IP address

Override traffic directed toward a specific IP address with a different IP address.

* Dashboard

  | Selector | Operator | Value | Logic | Action |
  | - | - | - | - | - |
  | Destination IP | in | `203.0.113.17` | And | Network Override |
  | Destination Port | is | `80` | | |

  | Override IP | Override Port |
  | - | - |
  | `1.1.1.1` | `80` |

* API

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zero Trust Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "Override example.com with 1.1.1.1",
      "description": "Override a site'\''s IP address with another IP",
      "enabled": true,
      "action": "l4_override",
      "filters": [
          "l4"
      ],
      "traffic": "net.dst.ip in {203.0.113.17} and net.dst.port == 80",
      "identity": "",
      "device_posture": "",
      "rule_settings": {
          "l4override": {
              "ip": "1.1.1.1",
              "port": 80
          },
          "override_host": "",
          "override_ips": null
      }
    }'
  ```
