---
title: Redirect one domain to another · Cloudflare Fundamentals docs
description: If you have an alias domain that only forwards traffic to another
  domain (that is, the domain does not have an associated origin server of its
  own), you can set up redirects directly within Cloudflare.
lastUpdated: 2025-08-20T13:33:03.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/fundamentals/manage-domains/redirect-domain/
  md: https://developers.cloudflare.com/fundamentals/manage-domains/redirect-domain/index.md
---

If you have an alias domain that only forwards traffic to another domain (that is, the domain does not have an associated origin server of its own), you can set up redirects directly within Cloudflare.

1. [Add](https://developers.cloudflare.com/fundamentals/manage-domains/#add-a-domain-to-cloudflare) your alias domain (for example, `previous.com`) to Cloudflare.

2. Make sure that your alias domain has a proxied [DNS A or CNAME record](https://developers.cloudflare.com/dns/manage-dns-records/how-to/create-dns-records/) that properly resolves DNS queries. You may also want to include a record for the `www` subdomain.

   Use the IP address `192.0.2.1` for the `A` record. This address does not route traffic to an origin server but allows Cloudflare to apply rules, redirects, and Workers to incoming traffic. The equivalent IP address for an `AAAA` record is `100::`.

   | **Type** | **Name** | **IPv4 address** | **Proxy status** |
   | - | - | - | - |
   | A | `@` | `192.0.2.1` | Proxied |
   | A | `www` | `192.0.2.1` | Proxied |

3. Use [Redirect rules](https://developers.cloudflare.com/rules/url-forwarding/) to forward traffic from your alias domain to your other domain.

This example will redirect all requests for `smallshop.example.com` to a different hostname using HTTPS, keeping the original path and query string.

**When incoming requests match**

* **Field:** *Hostname*
* **Operator:** *equals*
* **Value:** `smallshop.example.com`

If you are using the Expression Editor, enter the following expression:\
`(http.host eq "smallshop.example.com")`

**Then**

* **Type:** *Dynamic*
* **Expression:** `concat("https://globalstore.example.net", http.request.uri.path)`
* **Status code:** *301*
* **Preserve query string:** Enabled

For example, the redirect rule would perform the following redirects:

| Request URL | Target URL | Status code |
| - | - | - |
| `http://smallshop.example.com/` | `https://globalstore.example.net/` | `301` |
| `http://smallshop.example.com/admin/?logged_out=true` | `https://globalstore.example.net/admin/?logged_out=true` | `301` |
| `https://smallshop.example.com/?all_items=1` | `https://globalstore.example.net/?all_items=1` | `301` |
| `http://example.com/about/` | (unchanged) | n/a |
