---
title: MDM deployment · Cloudflare Learning Paths
description: Organizations can deploy WARP automatically to their fleet of
  devices in a single operation. The WARP client is compatible with the vast
  majority of managed deployment workflows, including mobility management
  solutions such as Intune or JAMF, or by executing an .msi file on desktop
  machines.
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/secure-internet-traffic/connect-devices-networks/mdm/
  md: https://developers.cloudflare.com/learning-paths/secure-internet-traffic/connect-devices-networks/mdm/index.md
---

Organizations can deploy WARP automatically to their fleet of devices in a single operation. The WARP client is compatible with the vast majority of managed deployment workflows, including [mobility management solutions](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/partners/) such as Intune or JAMF, or by executing an `.msi` file on desktop machines.

## MDM policy file

Refer to our [managed deployment instructions](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/) and create a `.plist`, `mdm.xml`, or `.msi` policy file based on your organization's software management tool.

[MDM parameters](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/parameters/) that you specify in a local policy file will overrule any [WARP settings](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/) configured in the dashboard.

Therefore, we recommend that your policy file only contain the organization name and potentially the onboarding flag, [relying on the dashboard](https://developers.cloudflare.com/learning-paths/secure-internet-traffic/configure-device-agent/device-profiles/) to configure the remaining device settings.

```xml
<dict>
  <key>organization</key>
  <string>your-team-name</string>
  <key>onboarding</key>
  <false/>
</dict>
```

1. In the [Cloudflare dashboard](https://dash.cloudflare.com/), select **Cloudflare One**.

   [Go to **Zero Trust**](https://one.dash.cloudflare.com/)

2. On the onboarding screen, choose a team name. The team name is a unique, internal identifier for your Zero Trust organization. Users will enter this team name when they enroll their device manually, and it will be the subdomain for your App Launcher (as relevant). Your business name is the typical entry.

3. Complete your onboarding by selecting a subscription plan and entering your payment details. If you chose the **Zero Trust Free plan**, this step is still needed but you will not be charged.
