---
title: FAQ · Cloudflare Magic Network Monitoring docs
description: Below you will find answers to our most commonly asked questions.
  If you cannot find the answer you are looking for, refer to the community page
  to explore more resources.
lastUpdated: 2025-10-16T11:21:23.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-network-monitoring/faq/
  md: https://developers.cloudflare.com/magic-network-monitoring/faq/index.md
---

Below you will find answers to our most commonly asked questions. If you cannot find the answer you are looking for, refer to the [community page](https://community.cloudflare.com/) to explore more resources.

## I am getting an "Invalid account settings request body: account name format contains illegal characters or is not supported" error when trying to create a rule.

This probably means that your account name has unsupported characters. Make sure your account name does not have characters like, for example, `&`, `<`, `>`, `"`, `'`, `` ` ``.

Refer to [Account name](https://developers.cloudflare.com/fundamentals/account/create-account/#account-name) to learn how to change your account name.

## Can I send NetFlow/sFlow data to Cloudflare in a secure, encrypted way?

Yes. Both enterprise and free customers can send encrypted network flow data to Cloudflare.

Enterprise customers with Magic Transit or Magic WAN are able to send encrypted network flow data via an IPsec tunnel to Cloudflare's network. You can achieve this by:

1. Configuring your [NetFlow](https://developers.cloudflare.com/magic-network-monitoring/routers/netflow-ipfix-config/) or [sFlow](https://developers.cloudflare.com/magic-network-monitoring/routers/sflow-config/) data to be sent to Cloudflare's network for parsing.
2. Directing that network flow data to be sent over [Magic Transit IPsec tunnels](https://developers.cloudflare.com/magic-transit/how-to/configure-tunnel-endpoints/) or [Magic WAN IPsec tunnels](https://developers.cloudflare.com/magic-wan/configuration/manually/how-to/configure-tunnel-endpoints/) to Cloudflare's network.

Cloudflare's network will then identify this traffic via the destination IP address/port, and direct the network flow traffic to Magic Network Monitoring for parsing.

Free customers can route their network flow traffic through a device that is running the WARP client. Then, network flow traffic can be forwarded from the WARP enabled device to Cloudflare's network flow endpoints. You can learn more about this in the [Encrypt network flow data tutorial](https://developers.cloudflare.com/magic-network-monitoring/tutorials/encrypt-network-flow-data/).

## I have Auto-Advertisement enabled and it was triggered by an attack. Do I have to turn Magic Transit off manually?

Once Auto-Advertisement is activated for an IP prefix that is under attack, the IP prefix will continue to be advertised by Cloudflare even if the attack ends. You will then need to manually disable advertisement for that IP prefix. Refer to [Configure dynamic advertisement](https://developers.cloudflare.com/byoip/concepts/dynamic-advertisement/best-practices/#configure-dynamic-advertisement) to learn how to withdraw your prefixes, and stop using Magic Transit.

## If Auto-Advertisement is enabled, and the threshold has been triggered, will the IP prefix show as advertised in the dashboard?

Yes, the IP prefix will show as advertised under the [IP Prefixes tab](https://developers.cloudflare.com/byoip/concepts/dynamic-advertisement/best-practices/#configure-dynamic-advertisement).

## Does Auto-advertisement also work with BGP-controlled advertisements?

No. Auto-advertisement only works with API-controlled advertisement, not BGP-controlled advertisement.

## In the API, Magic Network Monitoring rules have a `bandwidth_threshold` data field. Does the value for this field refer to bytes transferred or current throughput?

The threshold for a [Magic Network Monitoring rule](https://developers.cloudflare.com/api/resources/magic_network_monitoring/subresources/rules/methods/list/) has two values. The first value is `bandwidth_threshold`. This value is a measure of the total ingress throughput on a network at any given moment. The second value is `duration`. The `duration`value refers to the amount of time that `bandwidth_threshold` must be exceeded before an alert is sent to the customer.

For example, you create a Magic Network Monitoring rule with the following parameters:

```txt
"bandwidth_threshold": 50000000
"duration": "1m0s"
```

With this rule, your network needs to receive a throughput greater than 50,000,000 bits per second (50 Gigabits per second or Gbps) for 60 seconds. If both of these conditions are met, then Magic Network Monitoring will send you an alert.

## My router's public IP address is different from the IP address of my network flow `agent-ip`. I cannot change my network flow `agent-ip`, and I am not seeing my router's traffic in Magic Network Monitoring< analytics

It is recommended that you set your router's public IP address and network flow `agent-ip` to the same value. However, if you are unable to do this, you can register both your router's public IP and your network flow `agent-ip` in the Magic Network Monitoring [router configuration](https://developers.cloudflare.com/magic-network-monitoring/get-started/). This will prevent Magic Network Monitoring from blocking network traffic received from any unknown IP addresses, and will show your router's network flow data underneath the router's `agent-ip`.

## What is Magic Network Monitoring's data retention policy for Netflow/sFlow received from customer's routers?

Currently, all data received from a customer's router goes to our servers in the US. If you enable data sovereignty in Europe, you cannot currently use Magic Network Monitoring.

GraphQL analytics is retained for 90 days for enterprise customers. For non-enterprise customers, data retention is seven days. Cloudflare also retains data for six hours in the US, for threshold crossing detection.
