---
title: DHCP server · Cloudflare Magic WAN docs
description: "When you use a static IP address, Magic WAN Connector can also act
  as a DHCP server in your network. To enable this feature:"
lastUpdated: 2025-10-27T11:06:15.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-wan/configuration/connector/network-options/dhcp/dhcp-server/
  md: https://developers.cloudflare.com/magic-wan/configuration/connector/network-options/dhcp/dhcp-server/index.md
---

When you use a static IP address, Magic WAN Connector can also act as a DHCP server in your network. To enable this feature:

* Dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/) and select your account.
  2. Go to **Magic WAN** > **Connector on-ramps (beta)**.

  1) Select your Magic WAN Connector you want to configure > **Edit**.

  2) Select **Network Configuration**, and scroll down to **LAN configuration**.

  3) In **LAN configuration**, select the LAN where you want to enable DHCP server.

  4) Select **Edit**.

  5) Under **Static addressing**, select **This is a DHCP Server**. You also have to specify:

     * The DNS server address. You can have more than one IP address. Select **Add DNS Server** for each server you want to add.
     * The DHCP pool start
     * The DHCP pool end

* API

  Note

  You will need your [account ID](https://developers.cloudflare.com/fundamentals/account/find-account-and-zone-ids/) and [API Key](https://developers.cloudflare.com/fundamentals/api/get-started/keys/#view-your-global-api-key) to use the API.

  Create a [`PUT` request](https://developers.cloudflare.com/api/resources/magic_transit/subresources/sites/subresources/lans/methods/update/) to update the LAN where you want to enable DHCP server:

  Example:

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Magic WAN Write`
  * `Magic Transit Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/magic/sites/$SITE_ID/lans/$LAN_ID" \
    --request PUT \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "lan": {
          "static_addressing": {
              "dhcp_server": {
                  "dhcp_pool_end": "<IP_ADDRESS>",
                  "dhcp_pool_start": "<IP_ADDRESS>",
                  "dns_server": "<IP_ADDRESS>"
              }
          }
      }
    }'
  ```
