---
title: Cisco SD-WAN · Cloudflare Magic WAN docs
description: Cloudflare partners with Cisco's SD-WAN solution to provide users
  with an integrated SASE solution. The Cisco SD-WAN appliances (physical and
  virtual) manage subnets associated with branch offices and cloud instances.
  Anycast Tunnels are set up between these SD-WAN edge devices and Cloudflare to
  securely route Internet-bound traffic. This tutorial describes how to
  configure the Cisco Catalyst 8000 Edge Platforms (physical or virtual) in the
  SD-WAN mode for north-south (Internet-bound) use cases.
lastUpdated: 2025-10-17T13:46:10.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-wan/configuration/manually/third-party/viptela/
  md: https://developers.cloudflare.com/magic-wan/configuration/manually/third-party/viptela/index.md
---

Cloudflare partners with Cisco's SD-WAN solution to provide users with an integrated SASE solution. The Cisco SD-WAN appliances (physical and virtual) manage subnets associated with branch offices and cloud instances. Anycast Tunnels are set up between these SD-WAN edge devices and Cloudflare to securely route Internet-bound traffic. This tutorial describes how to configure the Cisco Catalyst 8000 Edge Platforms (physical or virtual) in the SD-WAN mode for north-south (Internet-bound) use cases.

## Prerequisites

Before setting up a connection between Cisco SD-WAN and Cloudflare, you must have:

* Purchased Magic WAN and Secure Web Gateway.
* Cloudflare provision Magic WAN and Secure Web Gateway.
* Received two Cloudflare tunnel endpoints (anycast IP address) assigned to Magic WAN.
* Cisco SD-WAN appliances (physical or virtual). This ensures specific Internet-bound traffic from the sites' private networks is routed over the anycast GRE tunnels to Secure Web Gateway to enforce a user's specific web access policies.
* A static IP pair to use with the tunnel endpoints. The static IPs should be `/31` addresses separate from the IPs used in the subnet deployment.
* Release 20.6 Controllers and vEdge Device Builds. You should also pair them with devices that are on at least version Cisco IOS XE SD-WAN 17.6. Refer to [Cisco documentation](https://www.cisco.com/c/en/us/support/docs/routers/sd-wan/215676-cisco-tac-and-bu-recommended-sd-wan-soft.html) to learn more Cisco softweare versions.

Note

The SASE integration between Cisco SD-WAN and Cloudflare SSE was validated with Cisco SD-WAN 20.6.2 version with Catalyst 8kv router. For connectivity, we used GRE tunnels.

## 1. Create a SIG template on Cisco vManage

Cisco vManage is Cisco's SD-WAN management tool that is used to manage all the SD-WAN appliances in branch offices.

For this example scenario, a generic template for `SIG-Branch` was created.

![Traffic flow diagram for GRE](https://developers.cloudflare.com/_astro/viptela-flow-diagram-gre.BGa0DR7d_1E1VCz.webp)

To create a Secure Internet Gateway (SIG) using vManage:

1. From **Cisco vManage** under **Configuration**, select **Generic** and **Add Tunnel**.
2. Refer to the table below for the setting fields and their options.

| Setting | Type/Detail |
| - | - |
| **Global Template** | Factory\_Default\_Global\_CISCO\_Template |
| **Cisco Banner** | Factory\_Default\_Retail\_Banner |
| **Policy** | Branch-Local-Policy |

**Transport & Management VPN settings**

| Setting | Type/Detail |
| - | - |
| **Cisco VPN 0** | GCP-Branch-VPN0 |
| **Cisco Secure Internet Gateway** | Branch-SIG-GRE-Template |
| **Cisco VPN Interface Ethernet** | GCP-Branch-Public-Internet-TLOC |
| **Cisco VPN Interface Ethernet** | GCP-VPN0-Interface |
| **Cisco VPN 512** | Default\_AWS\_TGW\_CSR\_VPN512\_V01 |

**Basic Information settings**

| Setting | Type/Detail |
| - | - |
| **Cisco System** | Default\_BootStrap\_Cisco\_System\_Template |
| **Cisco Logging** | Default\_Logging\_Cisco\_V01 |
| **Cisco AAA** | AWS-Branch-AAA-Template |
| **Cisco BFD** | Default\_BFD\_Cisco-V01 |
| **Cisco OMP** | Default\_AWS\_TGW\_CSR\_OMP\_IPv46\_... |
| **Cisco Security** | Default\_Security\_Cisco\_V01 |

When creating the Feature Template, you can choose values that apply globally or that are device specific. For example, the **Tunnel Source IP Address**, **Interface Name** and fields from **Update Tunnel** are device specific and should be chosen accordingly.

## 2. Create tunnels in vManage

From vManage, select **Configuration** > **Templates**. You should see the newly created template where you will update the device values.

Because the template was created to add GRE tunnels, you only need to update the device values. Note that **VPN0** is the default, and the WAN interface used to build the tunnel must be part of **VPN0**.

![Update template fields for GRE tunnel](https://developers.cloudflare.com/_astro/viptela-update-device-template-gre.BQZzlgJi_1KlKnW.webp)

## 3. Create tunnels in Cloudflare

Refer to [Configure tunnel endpoints](https://developers.cloudflare.com/magic-wan/configuration/manually/how-to/configure-tunnel-endpoints/) for more information on creating a GRE tunnel.

![Established GRE tunne in Cloudflash dashboard](https://developers.cloudflare.com/_astro/viptela-gre-tunnel.BI5bFdGE_Z2oknv3.webp)

## 4. Define static routes

Refer to [Configure static routes](https://developers.cloudflare.com/magic-wan/configuration/manually/how-to/configure-routes/#create-a-static-route) for more information on configuring your static routes.

![Established GRE static routes in Cloudflare dashboard](https://developers.cloudflare.com/_astro/viptela-gre-static-routes.xe2lnYh6_ZdqsAT.webp)

## 5. Validate traffic flow

In the example below, a request for `neverssl.com` was issued, which has a Cloudflare policy blocking traffic to `neverssl`.com.

On the client VM (192.168.30.3), a blocked response is visible.

![cURL example for a request to neverssl.com](https://developers.cloudflare.com/_astro/viptela-curl-traffic-flow.DiSsMVxM_ZCu0Ac.webp)

A matching blocked log line is visible from the Cloudflare logs.

![A blocked log from Gateway Activity Log in the Cloudflare dashboard](https://developers.cloudflare.com/_astro/viptela-gre-swg-traffic.DD7CHYgi_Z2hBM1W.webp)

## Add new tunnels using IPsec

IPsec tunnels to Cloudflare can only be created on Cisco 8000v in the router mode today. Refer to the [Cisco IOS XE](https://developers.cloudflare.com/magic-wan/configuration/manually/third-party/cisco-ios-xe/) for more information.
