---
title: Strict (SSL-Only Origin Pull) - SSL/TLS encryption modes · Cloudflare
  SSL/TLS docs
description: Regardless of whether the browser-to-Cloudflare connection uses
  HTTP or HTTPS, Cloudflare always connects to the origin over HTTPS with
  certificate validation.
lastUpdated: 2025-09-23T08:43:40.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/ssl-only-origin-pull/
  md: https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/ssl-only-origin-pull/index.md
---

Note

This method is only available for Enterprise zones.

When you set your encryption mode to **Strict (SSL-Only Origin Pull)**, connections to the origin will always be made using SSL/TLS, regardless of the scheme requested by the visitor.

The certificate presented by the origin will be validated the same as with [Full (strict) mode](https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/full-strict/).

## Use when

You want the most secure configuration available for your origin, you are an Enterprise customer, and you meet the requirements for [**Full (strict)** mode](https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/full-strict/).

## Required setup

The setup is generally the same as [**Full (strict)** mode](https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/full-strict/), but you select **Strict (SSL-Only Origin Pull)** for your encryption mode.

Note

In addition to **Strict (SSL-Only Origin Pull)** encryption, you can also set up [Authenticated Origin Pulls](https://developers.cloudflare.com/ssl/origin-configuration/authenticated-origin-pull/) to ensure all requests to your origin are evaluated before receiving a response.

### Process

* Dashboard

  To change your encryption mode in the dashboard:

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com) and select your account and domain.
  2. Go to **SSL/TLS**.
  3. Choose an encryption mode.

* API

  To adjust your encryption mode with the API, send a [`PATCH`](https://developers.cloudflare.com/api/resources/zones/subresources/settings/methods/edit/) request with `ssl` as the setting name in the URI path, and the `value` parameter set to your desired setting (`off`, `flexible`, `full`, `strict`, or `origin_pull`).

## Limitations

Depending on your origin configuration, you may have to adjust settings to avoid [Mixed Content errors](https://developers.cloudflare.com/ssl/troubleshooting/mixed-content-errors/) or [redirect loops](https://developers.cloudflare.com/ssl/troubleshooting/too-many-redirects/).
